/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SerialExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $
 */

//
// SerialExpressionStore.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.Utils;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.time.Time;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;


/**
 * This extension of FileExpressionStore uses Java serialization to persist
 * OpenWFE expressions to files (FileExpressionStore takes care of 
 * determining where and in which files the expressions have to get 
 * persisted).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 17:26:06 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: SerialExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SerialExpressionStore

    extends FileExpressionStore

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SerialExpressionStore.class.getName());
    */

    //
    // CONSTANTS (definitions)

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from FileExpressionStore

    protected void saveExpression 
        (final String fileName, final FlowExpression fe)
    throws 
        Exception
    {
        //log.debug("saveExpression() "+fe.getId());

        java.io.ObjectOutputStream oos = null;
        try
        {
            oos = new java.io.ObjectOutputStream
                (new java.io.FileOutputStream(fileName));

            oos.writeObject(fe);
            oos.flush();
        }
        finally
        {
            try { oos.close(); } catch (final Throwable t) { }
        }
    }

    protected FlowExpression loadExpression 
        (final String fileName)
    throws 
        Exception
    {
        //log.debug("loadExpression() "+fileName);

        java.io.ObjectInputStream ois = null;
        try
        {
            ois = new java.io.ObjectInputStream
                (new java.io.FileInputStream(fileName));

            final FlowExpression fe = (FlowExpression)ois.readObject();

            fe.setApplicationContext(getContext());
            
            return fe;
        }
        finally
        {
            try { ois.close(); } catch (final Throwable t) { }
        }
    }

    //
    // METHODS from Service

    // 
    // STATIC METHODS

}
