/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: BooleanFunctions.java 2012 2005-08-10 07:42:45Z jmettraux $
 */

//
// BooleanFunctions.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.functions;


import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpression;


/**
 * Functions are static methods accepting a workitem and an array of string
 * as arguments, and they return a String. Boolean combination functions
 * are implemented here.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: BooleanFunctions.java 2012 2005-08-10 07:42:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class BooleanFunctions
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BooleanFunctions.class.getName());

    //
    // CONSTANTS & co

    /**
     * The 'true' string.
     */
    public final static String S_TRUE = "true";

    /**
     * The 'false' string.
     */
    public final static String S_FALSE = "false";

    //
    // static methods (FUNCTIONS)

    /**
     * not
     */
    public static String not
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 1)
        {
            log.debug("not() no args : returning false.");
            return S_FALSE;
        }

        log.debug("not() args[0] is '"+args[0]+"'");

        return toString( ! toBoolean(args[0]));
    }

    /**
     * and
     */
    public static String and
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 1) return S_FALSE;

        for (int i=0; i<args.length; i++)
        {
            if ( ! toBoolean(args[i])) return S_FALSE;
        }

        return S_TRUE;
    }

    /**
     * or
     */
    public static String or
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 1) return S_FALSE;

        for (int i=0; i<args.length; i++)
        {
            if (toBoolean(args[i])) return S_TRUE;
        }

        return S_FALSE;
    }

    /**
     * xor
     */
    public static String xor
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 2) return S_FALSE;

        if (toBoolean(args[0]) ^ toBoolean(args[1])) return S_TRUE;

        return S_FALSE;
    }

    //
    // static methods

    /**
     * Will return true if s is not null and equals to "true" (case 
     * insensitive).
     */
    public static boolean toBoolean (final String s)
    {
        if (s == null) return false;

        log.debug("toBoolean() interpreting >"+s.trim().toLowerCase()+"<");

        return s.trim().toLowerCase().equals(S_TRUE);
    }

    /**
     * Will return "true" or "false".
     */
    public static String toString (final boolean b)
    {
        if (b) return S_TRUE;
        return S_FALSE;
    }

}
