/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkitemFunctions.java 2781 2006-06-09 20:30:09Z jmettraux $
 */

//
// WorkitemFunctions.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.functions;


import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;


/**
 * Functions are static methods accepting a workitem and an array of string
 * are implemented here.
 * Functions about workitems and their attributes are implemented here.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WorkitemFunctions.java 2781 2006-06-09 20:30:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WorkitemFunctions
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WorkitemFunctions.class.getName());

    //
    // CONSTANTS & co

    //
    // static methods (FUNCTIONS)

    /**
     * Dumping the whole wi or just a branch of its attribute tree.
     */
    public static String dumpfield
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        String key = "";
        if (args.length > 0) key = args[0];

        final Attribute a = CollectionAttribute
            .lookupAttribute(key, wi.getAttributes());

        final XmlWorkItemCoder coder = (XmlWorkItemCoder)Definitions
            .getXmlCoder(fe.context());

        try
        {
            return 
                coder.encodeAttribute(a).toString();
        }
        catch (final CodingException e)
        {
            log.info("dumpfield() failure", e);

            return "";
        }
    }

    /**
     * Returns the size of the given attribute, the attribute may be referenced 
     * by a 'path' like "customers.1.address"; the size of an attribute is -1 
     * for an undefined attribute, 1 for an attribute and 0+ for a 
     * MapAttribute or a ListAttribute.
     * The attribute's name (or path) is the first argument of the function.
     * If no argument is given, this method will return -2;
     */
    public static String attsize
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 1) return "-2";

        final Attribute a = wi.getAttributes().getField(args[0]);

        if (a == null) return "-1";

        if (a instanceof CollectionAttribute)
            return ""+((CollectionAttribute)a).size();

        return "1";
    }

}
