/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SqlHistory.java 2465 2006-04-12 18:38:58Z jmettraux $
 */

//
// SqlHistory.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.history;

import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import openwfe.org.engine.history.History;
import openwfe.org.engine.history.HistoryIterator;
import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * Storing workitem tracing into a relational database
 * (this implementation only cares about participant apply/reply)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SqlHistory.java 2465 2006-04-12 18:38:58Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SqlHistory

    extends AbstractHistory

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SqlHistory.class.getName());

    //
    // CONSTANTS & co

    /**
     * This parameter's value is the name of the SQL table where the
     * history will get 'inserted'. The default table name is 'owfehistory'.
     */
    public final static String P_TABLE_NAME = "tableName";

    protected final static String COLUMNS =
        "date_, engineid, wfdname, wfdrevision, wfdid, expression, "+
        "eventcode, participantname, message";

    //
    // FIELDS

    private OwfeDataSource dataSource = null;
    private String tableName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // determine data source

        this.dataSource = SqlUtils.lookupDataSource(context, serviceParams);

        log.info("dataSource set");

        //
        // determine table name
        
        this.tableName = MapUtils.getAsString
            (serviceParams, P_TABLE_NAME, "owfehistory");

        log.info("using tableName '"+this.tableName+"'");
    }

    //
    // METHODS from History

    protected String getInsertString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (");
        sb.append(COLUMNS);
        sb.append(" )");
        sb.append(" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ? )");

        return sb.toString();
    }

    /**
     * Overrides AbstractHistory.log() and threads the logging of 
     * history messages.
     */
    public void log
        (final FlowExpressionId fei, 
         final WorkItem wi,
         final String eventCode, 
         final String participantName,
         final String message)
    {
        (new Thread()
         {
             public void run ()
             {
                 doLog(fei, wi, eventCode, participantName, message);
             }
         }).start();
    }

    /**
     * Where the actual work is done.
     */
    protected void doLog 
        (final FlowExpressionId fei, 
         final WorkItem wi,
         final String eventCode, 
         final String participantName,
         final String message)
    {
        java.sql.PreparedStatement pst = null;
        try
        {
            pst = getDataSource().getConnection()
                .prepareStatement(getInsertString());

            int i = 1;
            
            pst.setString(i++, (new java.sql.Timestamp(System.currentTimeMillis())).toString());
            pst.setString(i++, fei.getEngineId());
            pst.setString(i++, fei.getWorkflowDefinitionName());
            pst.setString(i++, fei.getWorkflowDefinitionRevision());
            pst.setString(i++, fei.getWorkflowInstanceId());
            pst.setString(i++, fei.getExpressionName() + " " + fei.getExpressionId());
            pst.setString(i++, eventCode);

            if (participantName == null)
                pst.setString(i++, "");
            else
                pst.setString(i++, participantName);

            pst.setString(i++, message);

            pst.executeUpdate();
        }
        catch (final java.sql.SQLException se)
        {
            log.warn("Failed to log to history", se);

            getDataSource().logSQLException("log", log, se);
        }
        finally
        {
            SqlUtils.closeStatement(pst);
            getDataSource().releaseConnection();
        }
    }

    /**
     * Not yet implemented
     */
    public HistoryIterator browse
        (String workflowName,
         String workflowRevision,
         long workflowInstanceId,
         long dateFrom,
         long dateto)
    throws
        HistoryException
    {
        throw new HistoryException("Not yet implemented.");
    }

    //
    // METHODS

    public String getTableName ()
    {
        return this.tableName;
    }

    protected OwfeDataSource getDataSource ()
    {
        return this.dataSource;
    }

}
