/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WicUtils.java 2069 2005-08-21 10:58:24Z jmettraux $
 */

//
// WicUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.engine.workitem.CodingException;


/**
 * WorkItem Coder Utils.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-08-21 12:58:24 +0200 (Sun, 21 Aug 2005) $
 * <br>$Id: WicUtils.java 2069 2005-08-21 10:58:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WicUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WicUtils.class.getName());

    //
    // METHODS

    public static org.jdom.Element enforceElement 
        (final Object o, final String nodeName)
    throws 
        CodingException
    {
        if (o == null)
        {
            throw new CodingException
                ("Null element. Should be '"+nodeName+"'");
        }

        if ( ! (o instanceof org.jdom.Element))
        {
            throw new CodingException
                ("Object to decode should be of class 'org.jdom.Element'. "+
                 "Received a '"+o.getClass().getName()+"' instead.");
        }

        final org.jdom.Element elt = (org.jdom.Element)o;

        if ( ! elt.getName().equals(nodeName))
        {
            throw new CodingException
                ("Excpected a <"+nodeName+"> element not a <"+
                 elt.getName()+"> one.");
        }

        return elt;
    }

    public static void setAttribute 
        (org.jdom.Element elt, String attributeName, String attributeValue)
    {
        if (attributeValue == null) return;

        elt.setAttribute(attributeName, attributeValue);
    }

    public static org.jdom.Element fetchElementFromStream 
        (java.io.InputStream is)
    throws 
        CodingException
    {
        org.jdom.input.SAXBuilder builder = new org.jdom.input.SAXBuilder();

        org.jdom.Document doc = null;
        try
        {
            doc = builder.build(is);
            is.close();
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed to decode xml element", e);
        }

        return doc.getRootElement();
    }

    public static long getLong 
        (org.jdom.Element elt, String attributeName)
    throws 
        CodingException
    {
        return getLong(elt, attributeName, null);
    }

    public static long getLong
        (org.jdom.Element elt, String attributeName, long defaultValue)
    throws
        CodingException
    {
        return getLong(elt, attributeName, new Long(defaultValue));
    }

    private static long getLong 
        (org.jdom.Element elt, String attributeName, Long defaultValue)
    throws 
        CodingException
    {
        if (elt == null || attributeName == null)
        {
            throw new CodingException
                ("Cannot extract a long from a null element "+
                 "or a from a 'null' attribute");
        }

        String sLong = elt.getAttributeValue(attributeName);

        try
        {
            return Long.parseLong(sLong);
        }
        catch (NumberFormatException nfe)
        {
            if (defaultValue != null) return defaultValue.longValue();

            throw new CodingException
                ("Cannot extract a long from '"+sLong+"'");
        }
    }

    public static String toString (org.jdom.Element elt)
    {
        if (elt == null) return "<nil/>";

        try
        {
            org.jdom.output.XMLOutputter out = 
                new org.jdom.output.XMLOutputter();
            java.io.StringWriter writer = 
                new java.io.StringWriter();

            out.output(elt, writer);

            writer.flush();

            return writer.toString();
        }
        catch (java.io.IOException ie)
        {
            return 
                "Failed to output as string xml for element named '"+
                elt.getName()+"' : "+ie;
        }
    }

}
