/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkItemListener.java 2540 2006-05-03 12:43:09Z jmettraux $
 */

//
// WorkItemListener.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.listen;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;

import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.misc.IoUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;


/**
 * Fully implement this class to reply to expressions or launch workflows
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-03 14:43:09 +0200 (Wed, 03 May 2006) $
 * <br>$Id: WorkItemListener.java 2540 2006-05-03 12:43:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WorkItemListener

    extends AbstractService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WorkItemListener.class.getName());

    //
    // CONSTANTS (definitions)

    /**
     * The parameter 'workItemConsumer' is used to tell the listener
     * to which workitem consumer it should send the incoming workitems.
     */
    public final static String P_CONSUMER
        = "workItemConsumer";

    /**
     * By default, a workitem listener will use the consumer named (registered
     * in the application context) as 'consumer'.
     */
    public final static String DEFAULT_CONSUMER
        = "consumer";

    //
    // FIELDS

    private String consumerName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //this.consumerName = (String)serviceParams.get(P_CONSUMER);

        this.consumerName = 
            MapUtils.getAsString(serviceParams, P_CONSUMER, DEFAULT_CONSUMER);

        log.info
            ("Listener '"+this.getName()+
             "' uses Consumer '"+this.consumerName+"'");
    }

    //
    // METHODS

    /**
     * Returns the workitem consumer attached to this listener 
     * (as determined in the configuration file)
     */
    protected WorkItemConsumer getConsumer ()
    {
        return (WorkItemConsumer)getContext().lookup(this.consumerName);
    }

    /**
     * Given a workitem coder short name, returns an instance of the
     * workitem code.
     */
    protected WorkItemCoder getCoder (final String coderName)
    {
        final WorkItemCoderLoader coderLoader = Definitions
            .getWorkItemCoderLoader(getContext());

        //if (coderName == null) return coderLoader.getDefaultCoder();

        final WorkItemCoder result = coderLoader.getCoder(coderName);

        if (result == null)
        {
            log.debug
                ("getCoder() did not find coder named '"+coderName+
                 "' returning default coder");
            
            return coderLoader.getDefaultCoder();
        }

        return result;
    }

    /**
     * Extracts a workitem coder name from the incoming input stream.
     */
    protected String[] extractCoderNameAndLength (final Object o)
        throws java.io.IOException
    {
        final StringBuffer sbCoder = new StringBuffer();
        StringBuffer sbLength = null;

        while (true)
        {
            final char c = (char)IoUtils.read(o);

            if (c == '\n') break;

            if (c == ' ') 
            {
                if (sbLength != null) break;

                sbLength = new StringBuffer();
            }

            if (sbLength == null) 
                sbCoder.append(c);
            else 
                sbLength.append(c);
        }

        // skip next char (if new style)
        //
        if (sbLength != null) IoUtils.read(o);

        String length = "-1";
        if (sbLength != null) length = sbLength.toString().trim();

        log.debug("extractCoderName(is) coderName is >"+sbCoder.toString()+"<");
        log.debug("extractCoderName(is) length is >"+length+"<");

        return new String[] { sbCoder.toString(), length };
    }

    /**
     * Given the incoming inputstream (or ReadableByteChannel), determines 
     * the workitem coder instance that should decode the wrapped workitem.
     */
    protected Object[] determineCoderAndLength (final Object o)
        throws java.io.IOException
    {
        final String[] ss = extractCoderNameAndLength(o);

        return new Object[] { getCoder(ss[0]), new Integer(ss[1]) };
    }

}
