/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractService.java 2351 2006-02-25 10:55:57Z jmettraux $
 */

//
// WiMerge.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.tools;

import openwfe.org.Utils;
import openwfe.org.xml.XmlUtils;


/**
 * Merging workitems from an old engine to a newer one.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-02-25 11:55:57 +0100 (Sat, 25 Feb 2006) $
 * <br>$Id: AbstractService.java 2351 2006-02-25 10:55:57Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class WiMerge
{

    private static org.jdom.Element merge
        (final org.jdom.Element eWi1, final org.jdom.Element eWi2)
    {
        final org.jdom.Element eLastExpressionId1 = 
            eWi1.getChild("last-expression-id");
        final org.jdom.Element eLastExpressionId2 = 
            eWi2.getChild("last-expression-id");

        eLastExpressionId1.detach();
        eLastExpressionId2.detach();

        eWi2.addContent(eLastExpressionId1);

        return eWi2;
    }

    private static void printUsage ()
    {
        System.out.println();
        System.out.println("  USAGE :");
        System.out.println();
        System.out.println("  java WiMerge {wi-source} {wi-target} {dump-dir}");
        System.out.println();

        System.exit(-1);
    }

    public static void main (final String[] args)
        throws Exception
    {
        if (args.length < 3) printUsage();

        int index = 0;

        final String sourceFilename = args[index++];
        final String targetFilename = args[index++];

        String dumpDirPath = args[index++];
        if ( ! dumpDirPath.endsWith(java.io.File.separator))
            dumpDirPath += java.io.File.separator;

        final java.io.File sourceFile = new java.io.File(sourceFilename);
        final java.io.File targetFile = new java.io.File(targetFilename);

        final org.jdom.Element eWi1 = 
            XmlUtils.extractXml(sourceFilename, false);
        final org.jdom.Element eWi2 = 
            XmlUtils.extractXml(targetFilename, false);

        final org.jdom.Element eWi3 = merge(eWi1, eWi2);

        final String dumpFilename = dumpDirPath + sourceFile.getName();

        XmlUtils.save(dumpFilename, eWi3);

        System.out.println
            ("...dumped new workitem into "+dumpFilename);
    }
}
