/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AtomicAttribute.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// AtomicAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

/**
 * An attribute containing a single value (instance), this attribute class
 * is the father of all atomic attributes, ie attributes that are not lists
 * or maps, attributes that hold a single value.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: AtomicAttribute.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AtomicAttribute

    implements Attribute

{

    //
    // FIELDS

    /**
     * The wrapped value itself.
     */
    protected Object value = null;

    //
    // CONSTRUCTORS

    /* *
     * An empty constructor, for a null value.
     * /
    protected AtomicAttribute ()
    {
    }
     */
    
    /**
     * Wraps the object as the value of this new AtomicAttribute instance.
     */
    protected AtomicAttribute (final Object o)
    {
        this.value = o;
    }

    //
    // METHODS

    /**
     * Returns the object wrapped here.
     */
    public Object getValue ()
    {
        return this.value;
    }

    /**
     * Sets the atomic context wrapped inside here.
     */
    public void setValue (final Object value)
    {
        if (value == null)
            throw new IllegalArgumentException("Cannot set to a null value");

        this.value = value;
    }

    /**
     * Simply returns the hashcode of the wrapped value.
     */
    public int hashCode ()
    {
        //if (this.value == null) return -1; ??????????????
        //
        // there were no problem till now, so this shortcut is left
        // commented out...

        return this.value.hashCode();
    }

    public boolean equals (final Object o)
    {
        if (o == null || ! (o instanceof AtomicAttribute)) return false;

        return 
            this.value.equals(((AtomicAttribute)o).value);
    }

    /**
     * Child classes that are not abstract have to implement (provide a body) 
     * for this method. Declaring it here enforces this policy at compile 
     * time.
     */
    public abstract Object clone ();

    /**
     * Simply returns the wrapped value toString() result.
     */
    public String toString ()
    {
        //if (this.value == null) return null;

        return this.value.toString();
    }

}
