/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: HistoryItem.java 2717 2006-06-01 15:26:06Z jmettraux $
 */

//
// HistoryItem.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;
import openwfe.org.time.Time;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * A piece of an InFlowWorkItem history
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 17:26:06 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: HistoryItem.java 2717 2006-06-01 15:26:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class HistoryItem

    implements java.io.Serializable, Cloneable

{

    static final long serialVersionUID = -6342388322728713196L;

    //
    // FIELDS

    public String date = null;
    public String author = null;
    public String host = null;
    public String text = null;

    public String wfdName = "";
    public String wfdRevision = "";
    public String wfInstanceId = null;
    public String expressionId = null;

    //
    // CONSTRUCTORS

    public HistoryItem ()
    {
        super();
    }

    public HistoryItem (final FlowExpressionId fei)
    {
        super();

        this.date = Time.toIsoDate();
        this.wfdName = fei.getWorkflowDefinitionName();
        this.wfdRevision = fei.getWorkflowDefinitionRevision();
        this.wfInstanceId = fei.getWorkflowInstanceId();
        this.expressionId = fei.getExpressionId();
    }

    //
    // METHODS

    public String getDate () { return this.date; }
    public String getAuthor () { return this.author; }
    public String getHost () { return this.host; }
    public String getText () { return this.text; }

    public String getWorkflowDefinitionName () { return this.wfdName; }
    public String getWorkflowDefinitionRevision () { return this.wfdRevision; }
    public String getWorkflowInstanceId () { return this.wfInstanceId; }
    public String getExpressionId () { return this.expressionId; }


    public void setDate (String isoDate) { this.date = isoDate; }
    public void setAuthor (String s) { this.author = s; }
    public void setHost (String s) { this.host = s; }
    public void setText (String s) { this.text = s; }

    public void setWorkflowDefinitionName (String s) { this.wfdName = s; }
    public void setWorkflowDefinitionRevision (String s) { this.wfdRevision = s; }
    public void setWorkflowInstanceId (String s) { this.wfInstanceId = s; }
    public void setExpressionId (String s) { this.expressionId = s; }


    public Object clone ()
    {
        HistoryItem result = new HistoryItem();

        result.date = Utils.copyString(this.date);
        result.author = Utils.copyString(this.author);
        result.host = Utils.copyString(this.host);
        result.text = Utils.copyString(this.text);
        result.wfdName = Utils.copyString(this.wfdName);
        result.wfdRevision = Utils.copyString(this.wfdRevision);
        //result.wfInstanceId = this.wfInstanceId;
        result.wfInstanceId = Utils.copyString(this.wfInstanceId);
        result.expressionId = Utils.copyString(this.expressionId);

        return result;
    }

    /**
     * Returns an human readable dump of this instance of HistoryItem.
     */
    public String toString ()
    {
        final StringBuffer sb = new StringBuffer();

        sb
            .append("(")
            .append(this.getClass().getName())
            .append(" ")
            .append(" date=\"").append(this.date).append("\"")
            .append(" author=\"").append(this.author).append("\"")
            .append(" host=\"").append(this.host).append("\"")
            .append(" text=\"").append(this.text).append("\"")
            .append(" wfdName=\"").append(this.wfdName).append("\"")
            .append(" wfdRevision=\"").append(this.wfdRevision).append("\"")
            .append(" wfInstanceId=\"").append(this.wfInstanceId).append("\"")
            .append(" expressionId=\"").append(this.expressionId).append("\"")
            .append(")");

        return sb.toString();
    }

    //
    // STATIC METHODS

    /**
     * Deep copy of an history item list.
     */
    public static java.util.List copyHistoryList (final java.util.List history)
    {
        java.util.List result = new java.util.ArrayList(history.size());

        java.util.Iterator it = history.iterator();
        while (it.hasNext())
        {
            final HistoryItem hi = (HistoryItem)it.next();
            result.add(hi.clone());
        }

        return result;
    }

}
