/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MapAttribute.java 2797 2006-06-11 10:12:28Z jmettraux $
 */

//
// MapAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.ReflectionUtils;


/**
 * A dictionary of attributes
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-11 12:12:28 +0200 (Sun, 11 Jun 2006) $
 * <br>$Id: MapAttribute.java 2797 2006-06-11 10:12:28Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MapAttribute

    extends CollectionAttribute

{

    static final long serialVersionUID = -1843868545451617886L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MapAttribute.class.getName());
    */

    //
    // CONSTANTS and co

    /**
     * When someone requests the '__keyset' element of this map,
     * it will receive a ListAttribute containing all the
     * key elements of this map.
     */
    public final static String K_KEYSET
        = "__keyset__";

    //
    // FIELDS

    private java.util.Map map = new java.util.LinkedHashMap();

    //
    // CONSTRUCTORS

    public MapAttribute () 
    {
        super();
    }

    public MapAttribute (int initialCapacity) 
    {
        super();

        this.map = new java.util.LinkedHashMap(initialCapacity);
    }

    //
    // BEAN METHODS

    public java.util.Map getMap () { return this.map; }
    public void setMap (java.util.Map m) { this.map = m; }

    //
    // METHODS

    public java.util.Set keySet () 
    {
        return this.map.keySet();
    }

    public java.util.Collection values ()
    {
        return this.map.values();
    }

    public java.util.Set entrySet ()
    {
        return this.map.entrySet();
    }

    public Attribute get (final Attribute key)
    {
        return (Attribute)this.map.get(key);
    }

    public Attribute get (final String key)
    {
        if (key.equals(K_KEYSET))
            return new ListAttribute(this.map.keySet());

        return (Attribute)this.map.get(new StringAttribute(key));
    }

    public void put (final Attribute key, final Attribute value)
    {
        /*
        if (log.isDebugEnabled())
        {
            if (value == null)
                log.debug("put() removing key '"+key+"'");
            else
                //log.debug("put() adding key '"+key+"' -> '"+value+"'");
                log.debug("put() adding key '"+key+"'");
        }
        */

        if (value == null) 
            this.map.remove(key);
        else
            this.map.put(key, value);
    }

    public void remove (final Attribute key)
    {
        this.map.remove(key);
    }

    public int size ()
    {
        return this.map.size();
    }

    public int hashCode ()
    {
        return this.map.hashCode();
    }

    public Object clone ()
    {
        final MapAttribute clone = 
            (MapAttribute)ReflectionUtils.newInstance(this);

        java.util.Iterator it = this.map.keySet().iterator();
        while (it.hasNext())
        {
            Attribute key = (Attribute)it.next();
            Attribute value = this.get(key);

            //clone.put((Attribute)key.clone(), (Attribute)value.clone());
            
            //if (key != null)
            clone.put((Attribute)key.clone(), clone(value));
        }

        return clone;
    }

    private Attribute clone (final Attribute a)
    {
        if (a == null) return null;
        return (Attribute)a.clone();
    }

    /**
     * Adds the content of a given map attribute to this map attribute.
     */
    public void putAll (final MapAttribute ma)
    {
        this.map.putAll(ma.getMap());
    }

    /**
     * The equivalent of put(new StringAttribute(key), value). But this
     * is mainly a method required by CollectionAttribute, the parent class.
     * This method is used by setField in CollectionAttribute,
     * it has thus an internal value rather than an API value.
     */
    public void cput (final String key, final Attribute value)
    {
        put(new StringAttribute(key), value);
    }

    /* *
     * An attributePath is something like "customer.name.firstname",
     * this method lookups in this map to extract the Attribute instance
     * containing the value of the 'firstname'.
     * /
    public Attribute lookup (final String attributePath)
    {
        final int idot = attributePath.indexOf(".");

        if (idot < 0)
            return this.get(attributePath);

        final String childName = attributePath.substring(0, idot);
        final String restPath = attributePath.substring(idot+1);

        log.debug("lookup() childName >"+childName+"<");
        log.debug("lookup() restPath  >"+restPath+"<");

        final Attribute child = this.get(childName);

        if (child == null)
        {
            log.debug("lookup() no child found.");
            return null;
        }

        if ( ! (child instanceof MapAttribute))
        {
            log.debug("lookup() cannot lookup in a non-map attribute/field.");
            return null;
        }

        return ((MapAttribute)child).lookup(restPath);
    }
     */

    //
    // STATIC METHODS

}
