/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.dispatch;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.OpenWfeException;
import openwfe.org.ServiceException;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.time.Time;
import org.jdom.Element;

public class LocalDispatcher
implements WorkItemDispatcher {
    public static final String P_CONSUMER = "consumer";
    protected String name = null;
    protected ApplicationContext applicationContext = null;
    protected Map params = null;
    protected String consumerName = null;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        this.name = serviceName;
        this.applicationContext = context;
        this.params = serviceParams;
        this.consumerName = (String)this.params.get(P_CONSUMER);
        if (this.consumerName == null) {
            throw new ServiceException("Parameter 'consumer' is required for setting up service " + this.name);
        }
    }

    public Object dispatch(WorkItem wi) throws DispatchingException {
        if (wi instanceof InFlowWorkItem) {
            InFlowWorkItem ifwi = (InFlowWorkItem)wi;
            ifwi = (InFlowWorkItem)ifwi.clone();
            ifwi.setDispatchTime(Time.toIsoDate());
            wi = ifwi;
        }
        WorkItemConsumer consumer = (WorkItemConsumer)this.applicationContext.lookup(this.consumerName);
        try {
            return consumer.use(wi);
        }
        catch (OpenWfeException owe) {
            throw new DispatchingException("local dispatching to consumer '" + this.consumerName + "' failed", owe);
        }
    }

    public void stop() throws ServiceException {
    }

    public String getName() {
        return this.name;
    }

    public Element getStatus() {
        return new Element(this.getName());
    }
}

