/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BooleanExpression;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;

public abstract class ComparisonExpression
extends ZeroChildExpression
implements BooleanExpression {
    public static final String EQUALS = "equals";
    public static final String OTHER_PREFIX = "other-";
    public static final String TYPE = "type";

    protected abstract Boolean computeResult(Integer var1, InFlowWorkItem var2);

    public void apply(InFlowWorkItem wi) throws ApplyException {
        Integer result = this.compareValues(wi);
        ValueUtils.setBooleanResult(wi, this.computeResult(result, wi));
        this.applyToParent(wi);
    }

    public boolean orEquals(InFlowWorkItem wi) {
        String sEquals = this.lookupAttribute(EQUALS, wi);
        return "true".equalsIgnoreCase(sEquals) || "ok".equalsIgnoreCase(sEquals);
    }

    protected Integer compareValues(InFlowWorkItem wi) throws ApplyException {
        Object value = null;
        Object otherValue = null;
        try {
            value = this.determineValue(wi);
            otherValue = this.determineOtherValue(wi);
        }
        catch (ApplyException ae) {
            return null;
        }
        if (value == null && otherValue == null) {
            return new Integer(0);
        }
        if (value == null || otherValue == null) {
            if (value == null) {
                return new Integer(-1);
            }
            return new Integer(1);
        }
        return new Integer(Utils.compareValues((Object)value, (Object)otherValue));
    }

    protected Object determineValue(InFlowWorkItem wi) throws ApplyException {
        try {
            return ValueUtils.determineValue(this, wi);
        }
        catch (ValueException ve) {
            throw new ApplyException("Failed to determine value for comparison", (Throwable)((Object)ve));
        }
    }

    protected Object determineOtherValue(InFlowWorkItem wi) throws ApplyException {
        try {
            return ValueUtils.determineValue(OTHER_PREFIX, this, wi);
        }
        catch (ValueException ve) {
            throw new ApplyException("Failed to determine other value for comparison", (Throwable)((Object)ve));
        }
    }
}

