/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.sync.SyncExpression;
import openwfe.org.engine.expressions.sync.SyncUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;

public abstract class ConcurrentFlowExpression
extends CleanCompositeFlowExpression
implements SynchableExpression {
    private SyncExpression syncExpression = null;

    public SyncExpression getSyncExpression() {
        return this.syncExpression;
    }

    public void setSyncExpression(SyncExpression se) {
        this.syncExpression = se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(InFlowWorkItem wi) throws ApplyException {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.applyToParent(wi);
            return;
        }
        this.setSyncExpression(SyncUtils.determineSyncExpression(this, this.getChildren(), wi));
        ConcurrentFlowExpression concurrentFlowExpression = this;
        synchronized (concurrentFlowExpression) {
            FlowExpressionId child;
            int i;
            for (i = 0; i < this.getChildren().size(); ++i) {
                child = (FlowExpressionId)this.getChildren().get(i);
                this.getSyncExpression().addChild(child);
            }
            try {
                this.getSyncExpression().ready(this);
            }
            catch (ReplyException re) {
                throw new ApplyException("Failed to tag sync expression as 'ready'", (Throwable)((Object)re));
            }
            for (i = 0; i < this.getChildren().size(); ++i) {
                child = (FlowExpressionId)this.getChildren().get(i);
                this.getExpressionPool().apply(child, (InFlowWorkItem)wi.clone());
            }
            ConcurrentFlowExpression concurrentFlowExpression2 = this;
            synchronized (concurrentFlowExpression2) {
                this.storeItself();
            }
        }
    }
}

