/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.OpenWfeException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.Iterator;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.sync.SyncExpression;
import openwfe.org.engine.expressions.sync.SyncUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;

public class ConcurrentIteratorExpression
extends OneChildExpression
implements SynchableExpression {
    private Iterator iterator = null;
    private SyncExpression syncExpression = null;

    public Iterator getIterator() {
        return this.iterator;
    }

    public void setIterator(Iterator i) {
        this.iterator = i;
    }

    public SyncExpression getSyncExpression() {
        return this.syncExpression;
    }

    public void setSyncExpression(SyncExpression syncExpression) {
        this.syncExpression = syncExpression;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        this.iterator = new Iterator(this, wi);
        this.setSyncExpression(SyncUtils.determineSyncExpression(this, null, wi));
        try {
            while (this.iterator.hasNext()) {
                this.iterator.next(this, wi);
            }
            this.getSyncExpression().ready(this);
        }
        catch (OpenWfeException owe) {
            throw new ApplyException("Failed to iterate to first element", owe);
        }
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        this.getSyncExpression().reply(this, wi);
    }
}

