/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.ExpressionToUnbind;
import openwfe.org.engine.expressions.OneRawChildExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import org.apache.log4j.Logger;

public class CronExpression
extends OneRawChildExpression
implements Schedulable,
ExpressionToUnbind {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$CronExpression == null ? (class$openwfe$org$engine$expressions$CronExpression = CronExpression.class$("openwfe.org.engine.expressions.CronExpression")) : class$openwfe$org$engine$expressions$CronExpression).getName());
    public static final String A_TAB = "tab";
    public static final String A_LEVEL = "level";
    public static final String A_NAME = "name";
    private static final String V_CRON = "__cron__";
    public static final String EVT_CRON = "-cro";
    private String tab = null;
    private String name = null;
    private String level = null;
    private Long cronId = null;
    private InFlowWorkItem appliedItem = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$CronExpression;

    public String getTab() {
        return this.tab;
    }

    public String getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public Long getCronId() {
        return this.cronId;
    }

    public InFlowWorkItem getAppliedItem() {
        return this.appliedItem;
    }

    public void setTab(String s) {
        this.tab = s;
    }

    public void setLevel(String s) {
        this.level = s;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setCronId(Long l) {
        this.cronId = l;
    }

    public void setAppliedItem(InFlowWorkItem wi) {
        this.appliedItem = wi;
    }

    public void trigger(Object[] params) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("trigger() cron.id is  " + this.getId()));
                log.debug((Object)("trigger() cron.env is  " + this.getEnvironmentId()));
            }
            if (this.appliedItem == null) {
                return;
            }
            RawExpression child = (RawExpression)this.getRawChild().clone();
            child.getId().setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
            child.setEnvironmentId(this.getEnvironmentId());
            this.getExpressionPool().add(child);
            this.historyLog(this.appliedItem, EVT_CRON, null, "triggered");
            if (log.isDebugEnabled()) {
                log.debug((Object)("trigger() child is  " + child.getId()));
            }
            this.getLauncher().launchSub(this.appliedItem, null, child.getId(), new HashMap(0), true);
        }
        catch (Throwable t) {
            log.warn((Object)"trigger() problem", t);
        }
    }

    public Long reschedule(Scheduler s) {
        return s.schedule(this.tab, (Schedulable)this, new Object[0]);
    }

    public void unbind() throws PoolException {
        if (this.cronId == null) {
            return;
        }
        this.getExpressionPool().getScheduler().unschedule(this.cronId);
    }

    private void determineNameAndLevel(InFlowWorkItem wi) {
        StringBuffer sb = new StringBuffer();
        String sLevel = this.lookupAttribute(A_LEVEL, wi);
        String sName = this.lookupAttribute(A_NAME, wi);
        if (sLevel != null) {
            for (int i = 0; i < sLevel.length() && sb.length() < 2 && sLevel.charAt(i) == '/'; ++i) {
                sb.append('/');
            }
        } else if (sName != null) {
            if (sName.startsWith("//")) {
                sb.append("//");
            } else if (sName.startsWith("/")) {
                sb.append("/");
            }
        }
        this.name = this.removeSlashes(sName);
        this.level = sb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("determineNameAndLevel() '" + this.name + "' '" + this.level + "'"));
        }
    }

    private String removeSlashes(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("/")) {
            return this.removeSlashes(s.substring(1));
        }
        return s;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        if (this.getChildExpressionId() == null) {
            return;
        }
        this.fetchRawChild();
        this.getExpressionPool().removeExpression(this.getChildExpressionId());
        this.appliedItem = (InFlowWorkItem)wi.clone();
        this.tab = this.lookupAttribute(A_TAB, wi);
        if (this.tab == null) {
            throw new ApplyException("Missing attribute 'tab'");
        }
        this.cronId = this.reschedule(this.getExpressionPool().getScheduler());
        this.determineNameAndLevel(wi);
        Environment env = null;
        if (this.level.equals("")) {
            env = this.fetchEnvironment();
        } else if (this.level.equals("/")) {
            env = this.getExpressionPool().fetchRootEnvironment(this);
        } else if (this.level.equals("//")) {
            env = this.getExpressionPool().fetchEngineEnvironment();
        }
        this.getRawChild().setEnvironmentId(env.getId());
        String variableName = null;
        variableName = this.name == null ? this.level + V_CRON + this.cronId.toString() : this.level + V_CRON + this.name;
        Object o = this.lookupVariable(variableName);
        if (o != null && o instanceof CronExpression) {
            CronExpression ce = (CronExpression)o;
            this.getExpressionPool().getScheduler().unschedule(ce.getCronId());
        }
        this.bindVariable(variableName, this);
        this.applyToParent(wi);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

