/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class CursorExpression
extends CleanCompositeFlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$CursorExpression == null ? (class$openwfe$org$engine$expressions$CursorExpression = CursorExpression.class$("openwfe.org.engine.expressions.CursorExpression")) : class$openwfe$org$engine$expressions$CursorExpression).getName());
    public static final String F_COMMAND = "__cursor_command__";
    public static final String A_COMMAND_FIELD = "command-field";
    public static final String C_BACK = "back";
    public static final String C_SKIP = "skip";
    public static final String C_BREAK = "break";
    public static final String C_CANCEL = "cancel";
    public static final String C_REWIND = "rewind";
    public static final String C_CONTINUE = "continue";
    public static final String A_DISALLOW = "disallow";
    private int currentId = -1;
    private FlowExpressionId currentFei = null;
    private String cursorCommandField = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$CursorExpression;

    public int getCurrentId() {
        return this.currentId;
    }

    public FlowExpressionId getCurrentFei() {
        return this.currentFei;
    }

    public void setCurrentId(int i) {
        this.currentId = i;
    }

    public void setCurrentFei(FlowExpressionId fei) {
        this.currentFei = fei;
    }

    public String getCursorCommandField() {
        return this.cursorCommandField;
    }

    public void setCursorCommandField(String s) {
        this.cursorCommandField = s;
    }

    private List lookupDisallow(InFlowWorkItem wi) {
        String s = this.lookupAttribute(A_DISALLOW, wi);
        if (s == null) {
            return new ArrayList(0);
        }
        String[] ss = s.split(", *");
        return Arrays.asList(ss);
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        String sCommand;
        this.cursorCommandField = this.lookupAttribute(A_COMMAND_FIELD, wi, F_COMMAND);
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() command field is >" + this.cursorCommandField + "<"));
        }
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            if (this.isLoop()) {
                log.warn((Object)"apply() loop with no children !!!");
                throw new ApplyException("loop with no children !");
            }
            this.applyToParent(wi);
            return;
        }
        List lDisallow = this.lookupDisallow(wi);
        if (lDisallow.contains(sCommand = (sCommand = wi.getAttributes().sget(this.cursorCommandField)) == null ? "" : sCommand.trim())) {
            sCommand = "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() sCommand' is >" + sCommand + "<"));
        }
        if (sCommand.equals(C_BREAK) || sCommand.equals(C_CANCEL)) {
            this.applyToParent(wi);
            return;
        }
        this.currentId = sCommand.equals(C_REWIND) || sCommand.equals(C_CONTINUE) ? 0 : (sCommand.startsWith(C_BACK) || sCommand.startsWith(C_SKIP) ? (this.currentId += this.extractStep(sCommand)) : ++this.currentId);
        if (this.currentId < 0) {
            this.currentId = 0;
        }
        if (this.currentId >= this.getChildren().size()) {
            if (this.isLoop()) {
                this.currentId = 0;
            } else {
                this.applyToParent(wi);
                return;
            }
        }
        wi.getAttributes().puts(this.cursorCommandField, "");
        FlowExpressionId next = null;
        this.storeItself();
        next = (FlowExpressionId)this.getChildren().get(this.currentId);
        try {
            this.currentFei = this.getLauncher().launchSub(wi, this.getId(), next, null, true);
            this.storeItself();
        }
        catch (LaunchException e) {
            log.warn((Object)("apply() next expression failed .... " + next.toString()), (Throwable)((Object)e));
        }
    }

    private int extractStep(String cursorCommand) {
        int step;
        block5: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("extractStep() extract step from '" + cursorCommand + "'"));
            }
            String[] ss = cursorCommand.split("\\s+");
            step = 1;
            if (ss.length > 1) {
                try {
                    step = Integer.parseInt(ss[1]);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)("extractStep() cannot determine step in '" + cursorCommand + "'"), t);
                }
            }
        }
        if (cursorCommand.startsWith(C_BACK)) {
            step = -step;
        }
        return step;
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        try {
            this.apply(wi);
        }
        catch (ApplyException e) {
            throw new ReplyException("reply failure", (Throwable)((Object)e));
        }
    }

    public void applyToParent(InFlowWorkItem wi) throws ApplyException {
        wi.getAttributes().puts(this.cursorCommandField, "");
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId childId = (FlowExpressionId)it.next();
            this.getExpressionPool().removeExpression(childId);
        }
        super.applyToParent(wi);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        InFlowWorkItem wi = this.getExpressionPool().childCancel(this.currentFei);
        super.cancel();
        return wi;
    }

    public boolean isLoop() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

