/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;

public class EvalExpression
extends CleanCompositeFlowExpression
implements WithChildren {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$EvalExpression == null ? (class$openwfe$org$engine$expressions$EvalExpression = EvalExpression.class$("openwfe.org.engine.expressions.EvalExpression")) : class$openwfe$org$engine$expressions$EvalExpression).getName());
    public static final String A_FIELD = "field";
    private boolean evalTriggered = false;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$EvalExpression;

    public boolean getEvalTriggered() {
        return this.evalTriggered;
    }

    public void setEvalTriggered(boolean b) {
        this.evalTriggered = b;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        Content xml = null;
        try {
            String fieldName = this.lookupAttribute(A_FIELD, wi);
            String sXml = this.lookupAttribute("__value__", wi);
            if (log.isDebugEnabled()) {
                log.debug((Object)("apply() children : " + this.getChildren().size()));
            }
            if (fieldName != null) {
                xml = this.extractXmlFromField(wi, fieldName);
            } else {
                if (this.getChildren().size() > 0) {
                    FlowExpressionId childId = (FlowExpressionId)this.getChildren().get(0);
                    this.getExpressionPool().apply(childId, wi);
                    return;
                }
                xml = XmlUtils.extractXmlElement((String)sXml);
            }
        }
        catch (Exception e) {
            throw new ApplyException("failed to determine what to eval", e);
        }
        try {
            this.eval(wi, xml);
        }
        catch (Throwable t) {
            throw new ApplyException("evaluation failure", t);
        }
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        if (this.getEvalTriggered()) {
            this.replyToParent(wi);
            return;
        }
        try {
            this.eval(wi, this.extractXmlFromField(wi, "__result__"));
        }
        catch (Exception e) {
            throw new ReplyException("Failed to eval XML result", e);
        }
    }

    protected void eval(InFlowWorkItem wi, Content xml) throws Exception {
        RawExpression evalResult = this.getLauncher().eval(this, xml, wi);
        if (evalResult == null) {
            this.applyToParent(wi);
            return;
        }
        this.setEvalTriggered(true);
        this.storeItself();
        evalResult.apply(wi);
    }

    private Content extractXmlFromField(InFlowWorkItem wi, String fieldName) throws Exception {
        Attribute a = wi.getAttributes().get(fieldName);
        if (a != null) {
            if (a instanceof StringAttribute) {
                return XmlUtils.extractXmlElement((String)a.toString());
            }
            if (a instanceof XmlAttribute) {
                return ((XmlAttribute)a).getContent();
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

