/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.workitem.Attribute;

public class FlowExpressionId
implements Attribute {
    static final long serialVersionUID = -6456469702585696792L;
    private String engineId = null;
    private String initialEngineId = null;
    private String workflowDefinitionUrl = null;
    private String workflowDefinitionName = null;
    private String workflowDefinitionRevision = null;
    private String workflowInstanceId = null;
    private String expressionName = null;
    private String expressionId = null;
    private String owfeVersion = null;

    public String getEngineId() {
        return this.engineId;
    }

    public String getInitialEngineId() {
        return this.initialEngineId;
    }

    public String getWorkflowDefinitionUrl() {
        return this.workflowDefinitionUrl;
    }

    public String getWorkflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public String getWorkflowDefinitionRevision() {
        return this.workflowDefinitionRevision;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getExpressionName() {
        return this.expressionName;
    }

    public String getExpressionId() {
        return this.expressionId;
    }

    public String getOwfeVersion() {
        return this.owfeVersion;
    }

    public void setEngineId(String s) {
        this.engineId = s;
    }

    public void setInitialEngineId(String s) {
        this.initialEngineId = s;
    }

    public void setWorkflowDefinitionUrl(String s) {
        this.workflowDefinitionUrl = s;
    }

    public void setWorkflowDefinitionName(String s) {
        this.workflowDefinitionName = s;
    }

    public void setWorkflowDefinitionRevision(String s) {
        this.workflowDefinitionRevision = s;
    }

    public void setWorkflowInstanceId(String s) {
        this.workflowInstanceId = s;
    }

    public void setExpressionName(String s) {
        this.expressionName = s;
    }

    public void setExpressionId(String s) {
        this.expressionId = s;
    }

    public void setOwfeVersion(String s) {
        this.owfeVersion = s;
    }

    public String getParentWorkflowInstanceId() {
        return FlowExpressionId.extractParentWorkflowInstanceId(this.getWorkflowInstanceId());
    }

    public static String extractParentWorkflowInstanceId(String workflowInstanceId) {
        int i = workflowInstanceId.indexOf(".");
        if (i < 0) {
            return workflowInstanceId;
        }
        return workflowInstanceId.substring(0, i);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowExpressionId)) {
            return false;
        }
        FlowExpressionId fei = (FlowExpressionId)o;
        return Utils.stringEquals((String)this.engineId, (String)fei.engineId) && Utils.stringEquals((String)this.initialEngineId, (String)fei.initialEngineId) && Utils.stringEquals((String)this.workflowInstanceId, (String)fei.workflowInstanceId) && Utils.stringEquals((String)this.expressionId, (String)fei.expressionId) && Utils.stringEquals((String)this.expressionName, (String)fei.expressionName) && Utils.stringEquals((String)this.workflowDefinitionName, (String)fei.workflowDefinitionName) && Utils.stringEquals((String)this.workflowDefinitionRevision, (String)fei.workflowDefinitionRevision) && Utils.stringEquals((String)this.owfeVersion, (String)fei.owfeVersion);
    }

    public boolean isInSubFlow() {
        if (this.workflowInstanceId == null) {
            return false;
        }
        return this.workflowInstanceId.indexOf(".") > -1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() {
        FlowExpressionId result = new FlowExpressionId();
        result.engineId = Utils.copyString((String)this.engineId);
        result.initialEngineId = Utils.copyString((String)this.initialEngineId);
        result.workflowDefinitionUrl = Utils.copyString((String)this.workflowDefinitionUrl);
        result.workflowDefinitionName = Utils.copyString((String)this.workflowDefinitionName);
        result.workflowDefinitionRevision = Utils.copyString((String)this.workflowDefinitionRevision);
        result.workflowInstanceId = Utils.copyString((String)this.workflowInstanceId);
        result.expressionName = Utils.copyString((String)this.expressionName);
        result.expressionId = Utils.copyString((String)this.expressionId);
        result.owfeVersion = Utils.copyString((String)this.owfeVersion);
        return result;
    }

    public FlowExpressionId copy() {
        return (FlowExpressionId)this.clone();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("( fei ").append(this.owfeVersion).append(" ").append(this.engineId).append("/").append(this.initialEngineId).append(" ").append(this.workflowDefinitionUrl).append(" ").append(this.workflowDefinitionName).append(" ").append(this.workflowDefinitionRevision).append(" ").append(this.workflowInstanceId).append(" ").append(this.expressionName).append(" ").append(this.expressionId).append(" )");
        return sb.toString();
    }

    public String asStringId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getEngineId());
        sb.append("_");
        sb.append(this.getWorkflowInstanceId());
        sb.append("_");
        sb.append(this.getExpressionName());
        sb.append("_");
        sb.append(this.getExpressionId());
        return sb.toString();
    }

    public String toParseableString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.normalize(this.owfeVersion)).append("|").append(this.normalize(this.engineId)).append("|").append(this.normalize(this.initialEngineId)).append("|").append(this.normalize(this.workflowDefinitionUrl)).append("|").append(this.normalize(this.workflowDefinitionName)).append("|").append(this.normalize(this.workflowDefinitionRevision)).append("|").append(this.normalize(this.workflowInstanceId)).append("|").append(this.normalize(this.expressionName)).append("|").append(this.normalize(this.expressionId));
        return sb.toString();
    }

    private String normalize(String in) {
        if (in == null) {
            return "";
        }
        return in;
    }

    public static FlowExpressionId fromParseableString(String s) {
        String[] ss;
        if (s == null) {
            return null;
        }
        if (s.endsWith("|")) {
            s = s + " ";
        }
        if ((ss = s.split("\\|")).length != 8 && ss.length != 9) {
            throw new IllegalArgumentException("Cannot parse FlowExpressionId out of >" + s + "< (length is " + ss.length + ")");
        }
        FlowExpressionId fei = new FlowExpressionId();
        int i = 0;
        fei.owfeVersion = ss.length == 9 ? ss[i++].trim() : "unknown";
        fei.engineId = ss[i++].trim();
        fei.initialEngineId = ss[i++].trim();
        fei.workflowDefinitionUrl = ss[i++].trim();
        fei.workflowDefinitionName = ss[i++].trim();
        fei.workflowDefinitionRevision = ss[i++].trim();
        fei.workflowInstanceId = ss[i++].trim();
        fei.expressionName = ss[i++].trim();
        fei.expressionId = ss[i++].trim();
        return fei;
    }
}

