/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.IntegerAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public class Iterator
implements Serializable {
    static final long serialVersionUID = -2532616767097005828L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$Iterator == null ? (class$openwfe$org$engine$expressions$Iterator = Iterator.class$("openwfe.org.engine.expressions.Iterator")) : class$openwfe$org$engine$expressions$Iterator).getName());
    public static final String VALUE_PREFIX = "on-";
    public static final String DEFAULT_TO_VARIABLE = "__iteration_value__";
    public static final String VALUE_SEPARATOR = "value-separator";
    public static final String DEFAULT_VALUE_SEPARATOR = ", *";
    public static final String F_ITERATION_POSITION = "__ip__";
    private int iterationPosition = -1;
    private List iterationList = null;
    private FlowExpressionId templateId = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$Iterator;

    public Iterator() {
    }

    public Iterator(FlowExpression iteratingExpression, InFlowWorkItem wi) throws ApplyException {
        this.prepareIterationList(iteratingExpression, wi);
    }

    public int getIterationPosition() {
        return this.iterationPosition;
    }

    public List getIterationList() {
        return this.iterationList;
    }

    public FlowExpressionId getTemplateId() {
        return this.templateId;
    }

    public void setIterationPosition(int i) {
        this.iterationPosition = i;
    }

    public void setIterationList(List l) {
        this.iterationList = l;
    }

    public void setTemplateId(FlowExpressionId fei) {
        this.templateId = fei;
    }

    public Object currentIterationValue() {
        try {
            return this.iterationList.get(this.iterationPosition);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized boolean hasNext() {
        boolean result;
        if (this.iterationList == null || this.iterationList.size() < 1) {
            return false;
        }
        boolean bl = result = this.iterationPosition < this.iterationList.size() - 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasNext() ? " + result));
        }
        return result;
    }

    public synchronized void next(OneChildExpression iteratingExpression, InFlowWorkItem wi) throws OpenWfeException {
        if (this.templateId == null) {
            this.templateId = iteratingExpression.getChildExpressionId();
        }
        iteratingExpression.tag(wi);
        ++this.iterationPosition;
        if (log.isDebugEnabled()) {
            log.debug((Object)"next() tagged workitem");
            log.debug((Object)("next() iteratingExpression is " + iteratingExpression.getId()));
            log.debug((Object)("next() iterationPosition : " + this.iterationPosition));
            log.debug((Object)("next() currentIterationValue >" + this.currentIterationValue() + "<"));
        }
        try {
            Map vars = ValueUtils.determineAndSetTarget("to-", iteratingExpression, wi, this.currentIterationValue());
            Launcher launcher = Definitions.getLauncher(iteratingExpression.context());
            wi.getAttributes().put(F_ITERATION_POSITION, (Attribute)new IntegerAttribute(this.iterationPosition));
            FlowExpressionId launchedId = launcher.launchSub(wi, iteratingExpression.getId(), iteratingExpression.getChildExpressionId(), vars, true);
            this.addChild(iteratingExpression, launchedId);
        }
        catch (OpenWfeException owe) {
            throw new ApplyException("Failed to apply next scope", owe);
        }
        if (!this.hasNext()) {
            iteratingExpression.getExpressionPool().removeExpression(this.templateId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("next() removed template " + this.templateId));
            }
        }
    }

    protected void addChild(FlowExpression parent, FlowExpressionId childId) {
        if (parent == null) {
            log.info((Object)"addChildToParent() parent is null");
        }
        if (!(parent instanceof SynchableExpression)) {
            return;
        }
        ((SynchableExpression)parent).getSyncExpression().addChild(childId);
        parent.storeItself();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addChildToParent() added " + childId + " to " + parent.getId()));
        }
    }

    protected void prepareIterationList(FlowExpression iteratingExpression, InFlowWorkItem wi) throws ApplyException {
        Object val = null;
        try {
            val = ValueUtils.determineValue(VALUE_PREFIX, iteratingExpression, wi);
        }
        catch (ValueException ve) {
            throw new ApplyException("Failed to determine value to iterate on", (Throwable)((Object)ve));
        }
        String separatorRegex = (String)iteratingExpression.getAttributes().get(VALUE_SEPARATOR);
        if (separatorRegex == null) {
            separatorRegex = DEFAULT_VALUE_SEPARATOR;
        }
        if (val == null) {
            this.iterationList = null;
            log.debug((Object)"prepareIterationList() nothing to iterate on...");
        } else if (val instanceof List) {
            this.iterationList = (List)val;
        } else if (val instanceof String || val instanceof StringAttribute) {
            String[] ss = val.toString().split(separatorRegex);
            this.iterationList = new ArrayList(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                this.iterationList.add(ss[i].trim());
            }
        } else if (val instanceof MapAttribute) {
            MapAttribute ma = (MapAttribute)val;
            this.iterationList = new ArrayList(ma.values().size());
            java.util.Iterator it = ma.values().iterator();
            while (it.hasNext()) {
                this.iterationList.add(it.next().toString());
            }
        } else if (val instanceof ListAttribute) {
            ListAttribute la = (ListAttribute)val;
            this.iterationList = new ArrayList(la.size());
            java.util.Iterator it = la.iterator();
            while (it.hasNext()) {
                this.iterationList.add(it.next().toString());
            }
        } else {
            throw new ApplyException("value of class '" + val.getClass().getName() + "' is not suitable for iteration");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

