/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.Iterator;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public class ListRotateExpression
extends ZeroChildExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ListRotateExpression == null ? (class$openwfe$org$engine$expressions$ListRotateExpression = ListRotateExpression.class$("openwfe.org.engine.expressions.ListRotateExpression")) : class$openwfe$org$engine$expressions$ListRotateExpression).getName());
    public static final String A_FIELD_NAME = "field";
    public static final String A_SEPARATOR = "separator";
    public static final String DEFAULT_SEPARATOR = ",";
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ListRotateExpression;

    public void apply(InFlowWorkItem wi) throws ApplyException {
        Attribute a;
        String fieldName = this.lookupAttribute(A_FIELD_NAME, wi);
        String separator = this.lookupAttribute(A_SEPARATOR, wi);
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        if ((a = wi.getAttributes().getField(fieldName)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("apply() cannot perform rotation, no field named '" + fieldName + "'"));
            }
        } else if (a instanceof ListAttribute) {
            this.flatten(wi, fieldName, (ListAttribute)a, separator);
        } else {
            this.expand(wi, fieldName, a, separator);
        }
        this.applyToParent(wi);
    }

    private void flatten(InFlowWorkItem wi, String fieldName, ListAttribute la, String separator) {
        StringBuffer sb = new StringBuffer();
        Iterator it = la.iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(a.toString());
        }
        wi.getAttributes().puts(fieldName, sb.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("flatten() '" + fieldName + "' -> '" + sb.toString() + "'"));
        }
    }

    private void expand(InFlowWorkItem wi, String fieldName, Attribute a, String separator) {
        if (separator.equals("|")) {
            separator = "\\|";
        }
        String value = a.toString();
        String[] ss = value.split(separator);
        ListAttribute la = new ListAttribute(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            la.add(new StringAttribute(ss[i]));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("expand() " + i + " -> '" + ss[i] + "'"));
        }
        wi.getAttributes().put(fieldName, (Attribute)la);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

