/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.List;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneOrZeroChildExpression;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;

public abstract class OneChildExpression
extends OneOrZeroChildExpression {
    private FlowExpressionId childExpressionId = null;

    public FlowExpressionId getChildExpressionId() {
        return this.childExpressionId;
    }

    public void setChildExpressionId(FlowExpressionId fei) {
        this.childExpressionId = fei;
    }

    public void initWorkflowInstanceId(String workflowInstanceId) {
        super.initWorkflowInstanceId(workflowInstanceId);
        this.childExpressionId.setWorkflowInstanceId(workflowInstanceId);
    }

    public void init(ApplicationContext context, FlowExpressionId environmentId, FlowExpressionId parentId, FlowExpressionId id, RawExpression generatingExpression, Object raw, InFlowWorkItem currentWi) throws BuildException {
        super.init(context, environmentId, parentId, id, generatingExpression, raw, currentWi);
        List children = generatingExpression.prepareChildren(currentWi);
        children = generatingExpression.cleanChildren(children);
        if (children.size() > 0) {
            this.setChildExpressionId((FlowExpressionId)children.get(0));
        }
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        if (this.childExpressionId == null) {
            return;
        }
        this.getExpressionPool().apply(this.childExpressionId, wi);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        InFlowWorkItem wi = this.getExpressionPool().childCancel(this.childExpressionId);
        super.cancel();
        return wi;
    }

    public void removeChild(FlowExpressionId fei) {
        if (this.childExpressionId == null) {
            return;
        }
        if (this.childExpressionId.equals(fei)) {
            this.childExpressionId = null;
        }
    }
}

