/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FilterDefinitionExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.state.FrozenState;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.BooleanAttribute;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class ParticipantExpression
extends ZeroChildExpression
implements ExpressionWithTimeOut {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ParticipantExpression == null ? (class$openwfe$org$engine$expressions$ParticipantExpression = ParticipantExpression.class$("openwfe.org.engine.expressions.ParticipantExpression")) : class$openwfe$org$engine$expressions$ParticipantExpression).getName());
    public static final String A_REF = "ref";
    public static final String A_FILTER = "filter";
    private static final String HISTORY_TEXT = "ok";
    public static final String A_DESCRIPTION = "description";
    public static final String DESCRIPTION_FIELD_NAME = "__description__";
    public static final String A_DEFAULT_REF = "default-ref";
    public static final String A_FIELD_REF = "field-ref";
    public static final String A_VARIABLE_REF = "variable-ref";
    public static final String DEFAULT_FIELD_REF = "__next_participant__";
    public static final String A_ELSE_REF = "else-ref";
    public static final String A_FORGET = "forget";
    public static final String F_FORGOTTEN_FIELD = "__forgotten__";
    private Filter filter = null;
    private InFlowWorkItem appliedWorkitem = null;
    protected String description = null;
    protected Attribute oldDescriptionValue = null;
    protected String dynaParticipantName = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ParticipantExpression;

    public Filter getFilter() {
        return this.filter;
    }

    public InFlowWorkItem getAppliedWorkitem() {
        return this.appliedWorkitem;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public void setAppliedWorkitem(InFlowWorkItem wi) {
        this.appliedWorkitem = wi;
    }

    public void setParent(FlowExpressionId fei) {
        super.setParent(fei);
    }

    protected String getParticipantName(InFlowWorkItem wi) throws ApplyException {
        if (this.dynaParticipantName != null) {
            return this.dynaParticipantName;
        }
        String defaultParticipantName = this.lookupAttribute(A_DEFAULT_REF, wi);
        String ref = this.lookupAttribute(A_REF, wi);
        String fieldRef = this.lookupAttribute(A_FIELD_REF, wi);
        String variableRef = this.lookupAttribute(A_VARIABLE_REF, wi);
        if (fieldRef == null && variableRef == null) {
            fieldRef = DEFAULT_FIELD_REF;
        }
        Object participantName = null;
        if (ref != null) {
            participantName = ref;
        } else if (fieldRef != null && this.appliedWorkitem != null) {
            participantName = this.appliedWorkitem.getAttribute(fieldRef);
        } else if (variableRef != null) {
            participantName = this.lookupVariable(variableRef);
        }
        this.dynaParticipantName = participantName == null ? defaultParticipantName : participantName.toString();
        if (this.dynaParticipantName == null) {
            this.dynaParticipantName = this.lookupAttribute(A_REF, wi);
        }
        if (this.dynaParticipantName == null) {
            throw new ApplyException("Could not determine dynamically or statically the target participant. Is 'field-ref', 'variable-ref' or 'ref' set in the flow definition ?");
        }
        return this.dynaParticipantName;
    }

    protected Participant lookupParticipant(InFlowWorkItem wi) throws ApplyException {
        String participantName = this.getParticipantName(wi);
        ParticipantMap pMap = Definitions.getParticipantMap(this.context());
        if (pMap == null) {
            throw new ApplyException("Cannot find participantMap  service. Cannot retrieve any participant.");
        }
        Participant result = pMap.get(participantName);
        if (result == null) {
            throw new ApplyException("Participant '" + participantName + "' not found");
        }
        wi.setParticipantName(participantName);
        return result;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        boolean shouldForget;
        this.touchApplyTime();
        ValueUtils.cleanResult(wi);
        String s = this.lookupAttribute(A_FORGET, wi);
        boolean bl = shouldForget = s != null && s.trim().equals("true");
        if (this.getAttributes().keySet().contains(A_FILTER)) {
            String filterName = this.lookupAttribute(A_FILTER, wi);
            FilterDefinitionExpression fde = (FilterDefinitionExpression)this.lookupVariable(filterName);
            if (fde != null) {
                fde.setApplicationContext(this.context());
                this.filter = fde.buildFilter(wi);
            } else {
                log.warn((Object)("apply() did not find filter '" + filterName + "'"));
            }
        }
        this.description = this.lookupAttribute(A_DESCRIPTION, wi);
        this.tag(wi);
        this.appliedWorkitem = (InFlowWorkItem)wi.clone();
        if (this.description != null) {
            this.oldDescriptionValue = wi.getAttribute(DESCRIPTION_FIELD_NAME);
            wi.getAttributes().puts(DESCRIPTION_FIELD_NAME, this.description);
        }
        InFlowWorkItem itemToDispatch = wi;
        if (this.filter != null) {
            itemToDispatch = this.filter.constrain(wi);
        }
        if (shouldForget) {
            itemToDispatch.getAttributes().puts(F_FORGOTTEN_FIELD, "true");
        }
        this.storeItself();
        this.regularDispatch(itemToDispatch);
        if (shouldForget) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"apply() forget is set to 'true', resuming flow");
            }
            try {
                wi.getAttributes().remove(F_FORGOTTEN_FIELD);
                this.reply(wi);
            }
            catch (ReplyException e) {
                throw new ApplyException("participant with forget set to 'true' : failed to immediately reply to parent");
            }
        }
    }

    protected void dispatch(Participant participant, String participantName, InFlowWorkItem wi) throws ApplyException, DispatchingException {
        wi.setParticipantName(participantName);
        participant.dispatch(this.context(), wi);
    }

    protected void regularDispatch(InFlowWorkItem wi) {
        String pName = null;
        try {
            Participant p = this.lookupParticipant(wi);
            pName = this.getParticipantName(wi);
            this.dispatch(p, pName, wi);
            this.historyLog(wi, "+DIS", pName, this.getClass().getName());
            return;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("regularDispatch() failed to dispatch to '" + pName + "'"), t);
            }
            log.warn((Object)("regularDispatch() failed to dispatch to '" + pName + "'\n" + t));
            this.historyLog(wi, "-dsf", pName, "" + t);
            this.elseDispatch(wi);
            return;
        }
    }

    protected void elseDispatch(InFlowWorkItem wi) {
        String sElseList = this.lookupAttribute(A_ELSE_REF, wi);
        if (sElseList != null) {
            String[] ss = sElseList.split(",");
            for (int i = 0; i < ss.length; ++i) {
                String pName = ss[i].trim();
                if (pName.equals("")) continue;
                Participant p = this.getParticipantMap().get(pName);
                if (p == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("elseDispatch() unknown participant '" + pName + "', continuing."));
                    continue;
                }
                try {
                    this.dispatch(p, pName, wi);
                    this.historyLog(wi, "+DIS", "else-ref:" + pName, this.getClass().getName());
                }
                catch (Throwable t) {
                    log.warn((Object)("elseDispatch() failed to dispatch to '" + pName + "' " + t + ", continuing..."));
                    this.historyLog(wi, "-dsf", "else-ref:" + pName, "" + t);
                }
                return;
            }
        }
        log.warn((Object)("elseDispatch() freezing self : " + this.getId()));
        FrozenState frozenState = new FrozenState();
        frozenState.setAppliedItem(wi);
        this.setState(frozenState);
        this.storeItself();
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        if (this.filter != null) {
            wi = this.filter.enforce(this.appliedWorkitem, wi);
        }
        this.addHistoryItem(wi);
        if (this.description != null) {
            if (this.oldDescriptionValue != null) {
                wi.getAttributes().put(DESCRIPTION_FIELD_NAME, this.oldDescriptionValue);
            } else {
                wi.getAttributes().remove(DESCRIPTION_FIELD_NAME);
            }
        }
        wi.getAttributes().remove("__timed_out__");
        super.reply(wi);
    }

    protected void addHistoryItem(InFlowWorkItem wi) {
        if (wi.getHistory() == null) {
            wi.setHistory(new ArrayList(1));
        }
        HistoryItem hi = new HistoryItem(this.getId());
        try {
            hi.setAuthor("participant::" + this.getParticipantName(wi));
        }
        catch (ApplyException ae) {
            hi.setAuthor("participant::unknown");
        }
        try {
            InetAddress add = InetAddress.getLocalHost();
            hi.setHost(add.getHostName() + " / " + add.getHostAddress());
        }
        catch (UnknownHostException uhe) {
            hi.setHost("" + uhe);
        }
        hi.setText(HISTORY_TEXT);
        wi.getHistory().add(hi);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancel() --> " + this.getId()));
        }
        if (this.appliedWorkitem == null) {
            return null;
        }
        Participant participant = this.lookupParticipant(this.appliedWorkitem);
        CancelItem ci = new CancelItem(this.getId(), this.getParticipantName(this.appliedWorkitem));
        try {
            participant.dispatch(this.context(), ci);
            if (log.isDebugEnabled()) {
                log.debug((Object)"cancel() cancelItem dispatched");
            }
        }
        catch (DispatchingException de) {
            throw new ApplyException("Failed to notify participant '" + this.getParticipantName(this.appliedWorkitem) + "' with cancel item", (Throwable)((Object)de));
        }
        super.cancel();
        return this.appliedWorkitem;
    }

    public boolean isTimeOutActivated() {
        if (this.getApplyTime() == null || this.getState() instanceof FrozenState) {
            return false;
        }
        return this.determineTimeOut() != -1L;
    }

    public void timeOutReply() throws ReplyException {
        String participantName = "unknown";
        try {
            participantName = this.getParticipantName(this.appliedWorkitem);
        }
        catch (ApplyException e) {
            // empty catch block
        }
        this.appliedWorkitem.addHistoryItem(participantName, "participant timed out");
        this.historyLog(this.appliedWorkitem, "+TOU", participantName, "");
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() setting '__timed_out__' to 'true'");
        }
        this.appliedWorkitem.getAttributes().put("__timed_out__", (Attribute)new BooleanAttribute(true));
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() cancelling self...");
        }
        try {
            this.cancel();
        }
        catch (ApplyException ae) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to send cancel message", (Throwable)((Object)ae));
            }
            throw new ReplyException("Failed to send cancel message", (Throwable)((Object)ae));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() resuming flow");
        }
        super.reply(this.appliedWorkitem);
    }

    public Long determineTimeOut() {
        Long timeOut = TimeoutUtils.determineTimeout(this, this.appliedWorkitem);
        if (timeOut == null) {
            Participant participant = null;
            try {
                participant = this.lookupParticipant(this.appliedWorkitem);
            }
            catch (ApplyException ae) {
                log.info((Object)"determineTimeOut() Couldn't determine participant for timeout computation", (Throwable)((Object)ae));
            }
            if (participant != null) {
                String sTimeOut = null;
                if (participant.getParams() != null) {
                    sTimeOut = (String)participant.getParams().get("timeout");
                }
                timeOut = TimeoutUtils.determineTimeout(sTimeOut);
            }
        }
        if (timeOut == null) {
            timeOut = this.getExpressionPool().getExpressionTimeOut();
        }
        if (timeOut == null) {
            timeOut = new Long(-1L);
        }
        if (log.isDebugEnabled()) {
            if (timeOut > -1L) {
                log.debug((Object)("determineTimeOut() time out for participant is set to " + timeOut + " (" + Time.toTimeString((Long)timeOut, (boolean)false) + ")."));
            } else {
                log.debug((Object)"determineTimeOut() no time out for participant.");
            }
        }
        return timeOut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

