/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.CompositeFlowExpression;
import openwfe.org.engine.expressions.DefineExpression;
import openwfe.org.engine.expressions.DefinitionExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class ProcessDefinition
extends CleanCompositeFlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ProcessDefinition == null ? (class$openwfe$org$engine$expressions$ProcessDefinition = ProcessDefinition.class$("openwfe.org.engine.expressions.ProcessDefinition")) : class$openwfe$org$engine$expressions$ProcessDefinition).getName());
    private Map expressions = new HashMap(10);
    private DefineExpression self = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ProcessDefinition;

    public ProcessDefinition(ApplicationContext context, DefineExpression definition) throws BuildException {
        this.setApplicationContext(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ProcessDefinition(1)");
            log.debug((Object)("ProcessDefinition() definition : " + definition.getClass().getName() + "  " + definition.getId()));
        }
        this.setSelf(definition);
        this.setId(definition.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessDefinition() set ProcessDefinition id to " + this.getId()));
        }
    }

    public ProcessDefinition(ApplicationContext context, String wfdUrl, String wfdName, String wfdRevision) throws BuildException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ProcessDefinition(2)");
        }
        this.setApplicationContext(context);
        FlowExpressionId id = new FlowExpressionId();
        id.setOwfeVersion("1.7.1pre7");
        id.setWorkflowDefinitionUrl(wfdUrl);
        id.setWorkflowDefinitionName(wfdName);
        id.setWorkflowDefinitionRevision(wfdRevision);
        this.setId(id);
        DefineExpression de = new DefineExpression();
        HashMap<String, String> deParams = new HashMap<String, String>();
        deParams.put("name", wfdName);
        deParams.put("revision", wfdRevision);
        de.init(this.context(), null, null, this.getId(), null, deParams, null);
        this.setSelf(de);
        this.setId(de.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessDefinition() set ProcessDefinition id to " + this.getId()));
        }
    }

    public Map getExpressions() {
        return this.expressions;
    }

    public DefineExpression getSelf() {
        return this.self;
    }

    public void setExpressions(Map m) {
        this.expressions = m;
    }

    public void setSelf(DefineExpression self) {
        this.self = self;
    }

    public void removeChild(FlowExpressionId fei) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeChild() from  " + this.getId()));
            log.debug((Object)("removeChild() before :  " + this.getExpressions().size()));
            log.debug((Object)("removeChild() before\n" + this.toString()));
        }
        this.getChildren().remove(fei);
        this.getExpressions().remove(fei);
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeChild() after  :  " + this.getExpressions().size()));
        }
        Iterator it = this.getExpressions().values().iterator();
        while (it.hasNext()) {
            this.removeChildFromExpression(fei, (FlowExpression)it.next());
        }
        this.removeChildFromExpression(fei, this.self);
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeChild() after \n" + this.toString()));
        }
    }

    private void removeChildFromExpression(FlowExpressionId childId, FlowExpression fe) {
        OneChildExpression oce;
        if (fe == null) {
            return;
        }
        if (fe instanceof CompositeFlowExpression) {
            CompositeFlowExpression cfe = (CompositeFlowExpression)((Object)fe);
            cfe.getChildren().remove(childId);
        } else if (fe instanceof OneChildExpression && (oce = (OneChildExpression)fe).getChildExpressionId() != null && oce.getChildExpressionId().equals(childId)) {
            oce.setChildExpressionId(null);
        }
    }

    public FlowExpression get(FlowExpressionId fei) {
        return (FlowExpression)this.getExpressions().get(fei);
    }

    public void add(FlowExpression fe) {
        this.addChild(fe.getId());
        this.getExpressions().put(fe.getId(), fe);
    }

    public void add(String expressionName, FlowExpressionId parentId, int position) throws BuildException {
        FlowExpression parent = null;
        parent = parentId != null ? (FlowExpression)this.getExpressions().get(parentId) : this.getSelf();
        FlowExpression fe = this.getExpressionMap().instantiateExpression(expressionName);
        FlowExpressionId id = parent.getId().copy();
        int c = this.newChildId(parent);
        if (c < 0) {
            throw new BuildException("Cannot add child to an expression of class " + parent.getClass());
        }
        id.setExpressionName(expressionName);
        id.setExpressionId(parent.getId().getExpressionId() + "." + c);
        fe.setId(id);
        fe.setParent(parentId);
        this.getExpressions().put(fe.getId(), fe);
        this.addChild(parent, fe.getId(), position);
    }

    private void addChild(FlowExpression parent, FlowExpressionId childId, int position) {
        if (parent instanceof CompositeFlowExpression) {
            ((CompositeFlowExpression)((Object)parent)).addChild(childId, position);
        } else if (parent instanceof OneChildExpression) {
            ((OneChildExpression)parent).setChildExpressionId(childId);
        }
    }

    private int getChildId(FlowExpressionId fei) {
        int i = fei.getExpressionId().lastIndexOf(".");
        if (i < 0) {
            return Integer.parseInt(fei.getExpressionId());
        }
        return Integer.parseInt(fei.getExpressionId().substring(i + 1));
    }

    private int newChildId(FlowExpression fe) {
        if (fe instanceof CompositeFlowExpression) {
            List children = ((CompositeFlowExpression)((Object)fe)).getChildren();
            if (children == null || children.size() < 1) {
                return 0;
            }
            int result = 0;
            Iterator it = children.iterator();
            while (it.hasNext()) {
                int c = this.getChildId((FlowExpressionId)it.next());
                if (c <= result) continue;
                result = c;
            }
            return ++result;
        }
        if (fe instanceof OneChildExpression) {
            OneChildExpression oce = (OneChildExpression)fe;
            if (oce.getChildExpressionId() == null) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public FlowExpression getRootExpression() {
        Iterator it = this.getExpressions().values().iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            if (fe instanceof DefineExpression) continue;
            return fe;
        }
        return null;
    }

    public FlowExpression getExpression(String expId) {
        Iterator it = this.getExpressions().values().iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            if (!expId.equals(fe.getId().getExpressionId())) continue;
            return fe;
        }
        return null;
    }

    public FlowExpressionId getFlowExpressionId(String expId) {
        FlowExpression fe = this.getExpression(expId);
        if (fe == null) {
            return null;
        }
        return fe.getId();
    }

    public void changeSubProcessDefinitionName(String defineExpId, String newName) {
        DefineExpression def = (DefineExpression)this.getExpression(defineExpId);
        def.getAttributes().put("name", newName);
    }

    public void createSubDefinition(String parentExpId, String subDefName) {
        DefineExpression def = (DefineExpression)this.getExpression(parentExpId);
        if (def == null) {
            def = this.self;
        }
        DefineExpression subDef = new DefineExpression();
        FlowExpressionId subId = def.getId().copy();
        subId.setExpressionName("subprocess-definition");
        subId.setExpressionId(subId.getExpressionId() + "." + def.getChildren().size());
        subDef.setParent(def.getId());
        subDef.setId(subId);
        def.getChildren().add(subId);
        this.add(subDef);
    }

    public void removeSubDefinition(String defineExpId) {
        DefineExpression def = (DefineExpression)this.getExpression(defineExpId);
        if (def == null) {
            log.warn((Object)("removeSubDefinition() couldn't remove inexistent " + defineExpId));
            return;
        }
        this.removeChild(def.getId());
    }

    public String outputAsXmlString() throws BuildException {
        return XmlUtils.toString((Content)this.toXml(this.getSelf(), null, null));
    }

    public String toXmlString(FlowExpression fe) throws BuildException {
        return XmlUtils.toString((Content)this.toXml(fe, null, null));
    }

    public String doReplaceXml(FlowExpressionId fei, String newXml) throws BuildException {
        return XmlUtils.toString((Content)this.toXml(this.getSelf(), fei, newXml));
    }

    private Element toXml(FlowExpression fe, FlowExpressionId repId, String repXml) throws BuildException {
        OneChildExpression oce;
        if (fe == null) {
            return null;
        }
        if (fe.getId().equals(repId)) {
            try {
                return XmlUtils.extractXmlElement((String)repXml);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("toXml() failed to extract XML out of \n" + repXml), (Throwable)e);
                }
                throw new BuildException("failed to extract XML out of \n" + repXml, e);
            }
        }
        String expName = this.getExpressionMap().getName(fe.getClass());
        Element elt = new Element(expName);
        XmlUtils.setAttributes((Element)elt, (Map)fe.getAttributes());
        if (fe instanceof CompositeFlowExpression) {
            CompositeFlowExpression cfe = (CompositeFlowExpression)((Object)fe);
            Iterator it = cfe.getChildren().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof FlowExpressionId)) {
                    elt.addContent((Content)new Text(o.toString()));
                    continue;
                }
                FlowExpressionId fei = (FlowExpressionId)o;
                Element eResult = this.toXml(this.get(fei), repId, repXml);
                if (eResult == null) continue;
                elt.addContent((Content)eResult);
            }
        } else if (fe instanceof OneChildExpression && (oce = (OneChildExpression)fe).getChildExpressionId() != null) {
            elt.addContent((Content)this.toXml(this.get(oce.getChildExpressionId()), repId, repXml));
        }
        return elt;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
    }

    public String toString() {
        FlowExpressionId k;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" :\n");
        sb.append("   - id                 : ");
        sb.append(this.getId());
        sb.append("\n");
        sb.append(" children [\n");
        Iterator<Object> it = this.getChildren().iterator();
        while (it.hasNext()) {
            k = (FlowExpressionId)it.next();
            sb.append("     - ");
            sb.append(k);
            sb.append("\n");
        }
        sb.append(" ]");
        sb.append(" expression ids [\n");
        it = this.getExpressions().keySet().iterator();
        while (it.hasNext()) {
            k = (FlowExpressionId)it.next();
            sb.append("     - ");
            sb.append(k);
            sb.append("\n");
        }
        sb.append(" ]");
        return sb.toString();
    }

    public List getSubDefinitions(FlowExpression fe) {
        DefineExpression def = null;
        if (fe instanceof DefineExpression) {
            def = (DefineExpression)fe;
        } else if (fe instanceof ProcessDefinition) {
            def = ((ProcessDefinition)fe).getSelf();
        } else {
            throw new IllegalArgumentException("Illegal input : class " + fe.getClass().getName());
        }
        ArrayList<FlowExpression> result = new ArrayList<FlowExpression>(def.getChildren().size());
        Iterator it = def.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            FlowExpression fee = this.get(fei);
            if (!(fee instanceof DefineExpression)) continue;
            result.add(fee);
        }
        return result;
    }

    public FlowExpression getBody(DefineExpression de) {
        Iterator it = de.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            FlowExpression fe = this.get(fei);
            if (fe == null || fe instanceof DefinitionExpression) continue;
            return fe;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

