/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.sync.MergeUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public class RestoreExpression
extends ZeroChildExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$RestoreExpression == null ? (class$openwfe$org$engine$expressions$RestoreExpression = RestoreExpression.class$("openwfe.org.engine.expressions.RestoreExpression")) : class$openwfe$org$engine$expressions$RestoreExpression).getName());
    public static final String A_FROM_VARIABLE = "from-variable";
    public static final String A_MERGE_LEAD = "merge-lead";
    private static final String V_RESTORED = "restored";
    private static final String V_CURRENT = "current";
    public static final String A_TO_FIELD = "to-field";
    static /* synthetic */ Class class$openwfe$org$engine$expressions$RestoreExpression;

    private InFlowWorkItem fetchWorkitemToRestore(String variableName) {
        try {
            return (InFlowWorkItem)this.lookupVariable(variableName);
        }
        catch (ClassCastException cce) {
            log.warn((Object)"apply() stuff to restore is not a workitem");
            return null;
        }
    }

    private InFlowWorkItem doMerge(InFlowWorkItem wi, String variableName) {
        InFlowWorkItem restoredWorkitem;
        InFlowWorkItem newWorkitem = null;
        String mergeLead = this.lookupAttribute(A_MERGE_LEAD, wi);
        boolean theRestoredRules = V_RESTORED.equals(mergeLead);
        if (log.isDebugEnabled()) {
            if (theRestoredRules) {
                log.debug((Object)"apply() restored workitem has priority in merge");
            } else {
                log.debug((Object)"apply() current workitem has priority in merge");
            }
        }
        if ((restoredWorkitem = this.fetchWorkitemToRestore(variableName)) == null) {
            log.warn((Object)("apply() no workitem in variable '" + variableName + "'. Resuming."));
            return wi;
        }
        newWorkitem = mergeLead == null ? restoredWorkitem : (theRestoredRules ? MergeUtils.merge(wi, restoredWorkitem) : MergeUtils.merge(restoredWorkitem, wi));
        return newWorkitem;
    }

    private InFlowWorkItem doInsert(InFlowWorkItem wi, String variableName, String fieldName) {
        InFlowWorkItem restoredWorkitem = this.fetchWorkitemToRestore(variableName);
        if (restoredWorkitem == null) {
            log.warn((Object)("apply() no workitem in variable '" + variableName + "'. Resuming."));
            return wi;
        }
        wi.getAttributes().put(new StringAttribute(fieldName), (Attribute)restoredWorkitem.getAttributes());
        return wi;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        InFlowWorkItem newWorkitem = wi;
        String variableName = this.lookupAttribute(A_FROM_VARIABLE, wi);
        if (variableName == null) {
            log.warn((Object)"apply() no attribute 'from-variable' for expression, cannot restore anything.");
        } else {
            String toField = this.lookupAttribute(A_TO_FIELD, wi);
            newWorkitem = toField != null ? this.doInsert(wi, variableName, toField) : this.doMerge(wi, variableName);
        }
        this.applyToParent(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

