/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class RotateExpression
extends ZeroChildExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$RotateExpression == null ? (class$openwfe$org$engine$expressions$RotateExpression = RotateExpression.class$("openwfe.org.engine.expressions.RotateExpression")) : class$openwfe$org$engine$expressions$RotateExpression).getName());
    public static final String A_FIELD_NAME = "field";
    public static final String A_SEPARATOR = "separator";
    public static final String DEFAULT_SEPARATOR = ",";
    private static final String UU = "__";
    static /* synthetic */ Class class$openwfe$org$engine$expressions$RotateExpression;

    public void apply(InFlowWorkItem wi) throws ApplyException {
        String s;
        String fieldName = this.lookupAttribute(A_FIELD_NAME, wi);
        String separator = this.lookupAttribute(A_SEPARATOR, wi);
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        if ((s = wi.getAttributes().sget(fieldName)) == null) {
            this.flatten(wi, fieldName, separator);
        } else {
            this.expand(wi, fieldName, s, separator);
        }
        this.applyToParent(wi);
    }

    private void flatten(InFlowWorkItem wi, String fieldName, String separator) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (true) {
            String fn = fieldName + UU + i;
            String s = wi.getAttributes().sget(fn);
            if (i == 0 && s == null) {
                log.info((Object)("flatten() nothing to do (no field '" + fn + "')"));
                return;
            }
            if (s == null) break;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
            wi.getAttributes().remove(fn);
            ++i;
        }
        wi.getAttributes().puts(fieldName, sb.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("flatten() '" + fieldName + "' -> '" + sb.toString() + "'"));
        }
    }

    private void expand(InFlowWorkItem wi, String fieldName, String value, String separator) {
        if (separator.equals("|")) {
            separator = "\\|";
        }
        wi.getAttributes().remove(fieldName);
        String[] ss = value.split(separator);
        for (int i = 0; i < ss.length; ++i) {
            String fn = fieldName + UU + i;
            wi.getAttributes().puts(fn, ss[i]);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("expand() '" + fn + "' -> '" + ss[i] + "'"));
        }
        String fn = fieldName + UU + "count";
        wi.getAttributes().puts(fn, "" + ss.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("expand() '" + fn + "' -> '" + ss.length + "'."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

