/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.Utils;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ChildrenTracker;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import org.apache.log4j.Logger;

public class SubProcessRefExpression
extends ZeroChildExpression
implements WithChildren {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$SubProcessRefExpression == null ? (class$openwfe$org$engine$expressions$SubProcessRefExpression = SubProcessRefExpression.class$("openwfe.org.engine.expressions.SubProcessRefExpression")) : class$openwfe$org$engine$expressions$SubProcessRefExpression).getName());
    public static final String A_VARIABLE_REF = "variable-ref";
    public static final String A_FIELD_REF = "field-ref";
    public static final String A_REF = "ref";
    public static final String A_FORGET = "forget";
    public static final String A_FIELDS = "fields";
    public static final String V_CPARAMS = "__cparams__";
    public static final String ENGINE_SEPARATOR = "::";
    private FlowExpressionId subId = null;
    private boolean forgetting = false;
    private Map launchVariables = null;
    private ChildrenTracker tracker = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$SubProcessRefExpression;

    public FlowExpressionId getSubId() {
        return this.subId;
    }

    public void setSubId(FlowExpressionId fei) {
        this.subId = fei;
    }

    public boolean isForgetting() {
        return this.forgetting;
    }

    public void setForgetting(boolean b) {
        this.forgetting = b;
    }

    public Map getLaunchVariables() {
        return this.launchVariables;
    }

    public void setLaunchVariables(Map m) {
        this.launchVariables = m;
    }

    public ChildrenTracker getTracker() {
        return this.tracker;
    }

    public void setTracker(ChildrenTracker ct) {
        this.tracker = ct;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        this.forgetting = this.shouldForget(wi);
        String ref = this.determineReference(wi);
        ref = this.checkIfLocalEngine(ref);
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() ref >" + ref + "< for  " + this.getId()));
        }
        if (this.isUrl(ref)) {
            this.outerLaunch(wi, ref);
            return;
        }
        this.innerLaunch(wi, ref);
    }

    public synchronized void reply(InFlowWorkItem wi) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() from " + wi.getLastExpressionId()));
        }
        if (this.tracker == null) {
            log.debug((Object)"reply() no tracker : replying to parent.");
            this.replyToParent(wi);
            return;
        }
        this.tracker.reply(wi);
        if (this.tracker.hasNext()) {
            log.debug((Object)"reply() applying next child");
            this.tracker.applyNext(this);
            return;
        }
        this.launchVariables.put(V_CPARAMS, this.tracker.getRemainingContent());
        this.launchVariables.putAll(this.tracker.getResults());
        try {
            this.doLaunch(this.tracker.getWorkitem());
        }
        catch (ApplyException ae) {
            throw new ReplyException("'after children evaluation' sublaunch failure", (Throwable)((Object)ae));
        }
        this.tracker = null;
    }

    protected void outerLaunch(InFlowWorkItem wi, String ref) throws ApplyException {
        InFlowWorkItem launchWi = this.prepareSubWorkitem(wi);
        FlowExpressionId parentId = this.getId();
        if (this.isForgetting()) {
            parentId = null;
        } else {
            this.storeItself();
        }
        this.historyLog(wi, "+STA", null, "launching ref=\"" + ref + "\"");
        try {
            this.getLauncher().launch(launchWi, parentId, ref, this.areLaunchesAsync());
        }
        catch (LaunchException le) {
            throw new ApplyException("outer launch failure " + ref, (Throwable)((Object)le));
        }
        if (this.isForgetting()) {
            this.applyToParent(wi);
        }
    }

    public void innerLaunch(InFlowWorkItem wi, String ref) throws ApplyException {
        Object oValue;
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() ref is \"" + ref + "\""));
        }
        if ((oValue = this.lookupVariable(ref)) == null) {
            throw new ApplyException("ref '" + ref + "' points to nothing.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() oValue.class " + oValue.getClass().getName()));
        }
        if (!(oValue instanceof FlowExpressionId) && !(oValue instanceof RawExpression)) {
            log.warn((Object)("innerLaunch() oValue class : " + oValue.getClass().getName()));
            throw new ApplyException("ref '" + ref + "' doesn't point to a subprocess.");
        }
        RawExpression rawSub = null;
        if (oValue instanceof RawExpression) {
            rawSub = (RawExpression)oValue;
            rawSub = (RawExpression)rawSub.clone();
            rawSub.getId().setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
            try {
                this.getExpressionPool().add(rawSub);
            }
            catch (PoolException e) {
                throw new ApplyException("Failed to store new template into expression pool", (Throwable)((Object)e));
            }
            this.subId = rawSub.getId();
        } else {
            this.subId = (FlowExpressionId)oValue;
            FlowExpression re = this.getExpressionPool().fetch(this.subId);
            if (re == null) {
                throw new ApplyException("innerLaunch() subprocess '" + ref + "' points at  " + this.subId + " but it's gone from the expool");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("innerLaunch()  " + this.subId + "  is of class " + re.getClass().getName()));
            }
            rawSub = (RawExpression)re;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() inner subprocess at " + this.subId));
        }
        this.launchVariables = new HashMap();
        Iterator it = this.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.launchVariables.put(key, this.lookupAttribute(key, wi));
        }
        String s = rawSub.lookupAttribute("map-children", wi);
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() map-children=\"" + s + "\""));
        }
        String[] sChildrenToMap = null;
        if (s != null) {
            sChildrenToMap = s.split(",\\s*");
        }
        if (sChildrenToMap == null || sChildrenToMap.length < 1) {
            log.debug((Object)"innerLaunch() no children to map, launching directly");
            this.doLaunch(wi);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() childrenToMap.length : " + sChildrenToMap.length));
        }
        String sContent = (String)this.launchVariables.get("__content__");
        this.tracker = new ChildrenTracker();
        this.tracker.init(sContent, sChildrenToMap, wi);
        try {
            this.tracker.applyNext(this);
        }
        catch (ReplyException re) {
            throw new ApplyException("failed to begin with children evaluation", (Throwable)((Object)re));
        }
    }

    protected void doLaunch(InFlowWorkItem wi) throws ApplyException {
        String sContent;
        FlowExpressionId parentId = this.getId();
        if (this.isForgetting()) {
            parentId = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doLaunch() this.id is      " + this.getId()));
            log.debug((Object)("doLaunch() this.parent is  " + this.getParent()));
            log.debug((Object)("doLaunch() parentId is     " + parentId));
        }
        if ((sContent = (String)this.launchVariables.get("__content__")) != null && !this.launchVariables.keySet().contains(V_CPARAMS)) {
            this.launchVariables.put(V_CPARAMS, sContent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("doLaunch() cparams from content : " + sContent));
            }
        }
        try {
            this.getLauncher().launchSub((InFlowWorkItem)wi.clone(), parentId, this.subId, this.launchVariables, this.areLaunchesAsync());
        }
        catch (LaunchException le) {
            throw new ApplyException("Failed to launch inner subprocess  " + this.subId, (Throwable)((Object)le));
        }
        if (this.isForgetting()) {
            this.applyToParent(wi);
        }
    }

    private boolean isUrl(String ref) throws ApplyException {
        if (ref == null || ref.length() < 1) {
            throw new ApplyException("Cannot launch null or \"\" flow url");
        }
        if (Utils.isUrl((String)ref)) {
            return true;
        }
        int i = ref.indexOf(ENGINE_SEPARATOR);
        if (i > -1) {
            if (i + 2 == ref.length()) {
                return false;
            }
            return Utils.isUrl((String)ref.substring(i + 2));
        }
        return false;
    }

    public void setAttributes(Map m) {
        super.setAttributes(m);
    }

    protected boolean areLaunchesAsync() {
        return this.context().getBoolean("asyncLaunch", true);
    }

    private String checkIfLocalEngine(String reference) {
        if (reference.indexOf(ENGINE_SEPARATOR) < 0) {
            return reference;
        }
        String localEngineId = this.context().getApplicationName();
        if (localEngineId == null) {
            log.warn((Object)"application param 'engineId' is missing, cannot determine engineId");
            return reference;
        }
        String[] ss = reference.split(ENGINE_SEPARATOR);
        if (ss[0].equals(localEngineId)) {
            return ss[1];
        }
        return reference;
    }

    protected String determineReference(InFlowWorkItem wi) throws ApplyException {
        String varName = this.lookupAttribute(A_VARIABLE_REF, wi);
        if (varName != null) {
            String ref = (String)this.lookupVariable(varName);
            if (ref == null) {
                throw new ApplyException("no variable set under name '" + varName + "'");
            }
            return ref;
        }
        String fieldName = this.lookupAttribute(A_FIELD_REF, wi);
        if (fieldName != null) {
            Attribute aRef = wi.getAttributes().get(fieldName);
            String ref = null;
            if (aRef != null) {
                ref = aRef.toString();
            }
            if (ref == null) {
                throw new ApplyException("workitem holds no field named '" + fieldName + "'");
            }
            return ref;
        }
        String ref = this.lookupAttribute(A_REF, wi);
        if (ref == null) {
            throw new ApplyException("No 'variable-ref', 'field-ref' or 'ref' attribute in 'subprocess' expression");
        }
        return ref;
    }

    private void addFieldsFromRegex(String regex, InFlowWorkItem parentWi, InFlowWorkItem newWi) {
        Iterator it = parentWi.getAttributes().keyNamesMatching(regex).iterator();
        while (it.hasNext()) {
            String fieldName = ((String)it.next()).trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("prepareFields() adding field '" + fieldName + "'"));
            }
            Attribute a = parentWi.getAttribute(fieldName);
            newWi.getAttributes().put(new StringAttribute(fieldName), a);
        }
    }

    private void addFieldWithValue(String assignation, InFlowWorkItem newWi) {
        String[] ss = assignation.split(" *= *");
        String fieldName = ss[0].trim();
        String value = ss[1].trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addFieldWithValue() newWi['" + fieldName + "'] = '" + value + "'"));
        }
        newWi.getAttributes().put(new StringAttribute(fieldName), (Attribute)new StringAttribute(value));
    }

    private void addFieldAlias(String aliasing, InFlowWorkItem parentWi, InFlowWorkItem newWi) {
        String[] ss = aliasing.split(" *as *");
        String newFieldName = ss[0].trim();
        String parentFieldName = ss[1].trim();
        Attribute parentValue = parentWi.getAttribute(parentFieldName);
        if (parentValue != null) {
            newWi.getAttributes().put(new StringAttribute(newFieldName), parentValue);
        }
    }

    private InFlowWorkItem prepareSubWorkitem(InFlowWorkItem parentWi) {
        String sFields = this.lookupAttribute(A_FIELDS, parentWi);
        InFlowWorkItem newWi = (InFlowWorkItem)parentWi.clone();
        if (sFields == null) {
            return newWi;
        }
        newWi.setAttributes(new StringMapAttribute());
        String[] fields = sFields.split(", *");
        for (int i = 0; i < fields.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("prepareFields() considering '" + fields[i] + "'..."));
            }
            if (fields[i].indexOf("=") > -1) {
                this.addFieldWithValue(fields[i], newWi);
                continue;
            }
            if (fields[i].indexOf(" as ") > -1) {
                this.addFieldAlias(fields[i], parentWi, newWi);
                continue;
            }
            this.addFieldsFromRegex(fields[i], parentWi, newWi);
        }
        return newWi;
    }

    private boolean shouldForget(InFlowWorkItem wi) {
        if (Utils.toBoolean((Object)wi.getAttribute(A_FORGET))) {
            return true;
        }
        if (Utils.toBoolean((Object)this.lookupVariable(A_FORGET))) {
            return true;
        }
        return Utils.toBoolean((Object)this.lookupAttribute(A_FORGET, wi));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

