/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.AbstractFlowExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.functions.FunctionMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.BooleanAttribute;
import openwfe.org.engine.workitem.DoubleAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.IntegerAttribute;
import openwfe.org.engine.workitem.LongAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.misc.ArgParser;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public abstract class ValueUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ValueUtils == null ? (class$openwfe$org$engine$expressions$ValueUtils = ValueUtils.class$("openwfe.org.engine.expressions.ValueUtils")) : class$openwfe$org$engine$expressions$ValueUtils).getName());
    private static final String VALUE = "value";
    private static final String FIELD_VALUE = "field-value";
    private static final String VARIABLE_VALUE = "variable-value";
    private static final String FUNCTION_VALUE = "function-value";
    private static final String FIELD_TARGET = "field";
    private static final String VARIABLE_TARGET = "variable";
    private static final String OVERRIDE = "override";
    private static final String TYPE = "type";
    public static final String F_RESULT = "__result__";
    private static final String T_LONG = "long";
    private static final String T_DOUBLE = "double";
    private static final String T_BOOLEAN = "boolean";
    private static final String T_INTEGER = "integer";
    private static final ArgParser argParser = new ArgParser();
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ValueUtils;

    public static String executeFunction(FlowExpression expression, InFlowWorkItem wi, String functionCall) {
        int i = functionCall.indexOf("(");
        if (i < 0) {
            return ValueUtils.executeFunction(expression, wi, functionCall + "()");
        }
        String functionName = functionCall.substring(0, i);
        int j = functionCall.lastIndexOf(")");
        String rawArgs = functionCall.substring(i + 1, j);
        String[] args = argParser.parse(rawArgs);
        FunctionMap functionMap = Definitions.getFunctionMap(expression.context());
        return functionMap.eval(functionName, expression, wi, args);
    }

    public static String lookupConstant(String constantName) {
        int i = constantName.lastIndexOf(".");
        if (i > -1) {
            String className = constantName.substring(0, i);
            String constName = constantName.substring(i + 1);
            try {
                Class<?> clazz = Class.forName(className);
                Field field = clazz.getDeclaredField(constName);
                Object o = field.get(null);
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return "cannot lookup constant \"" + constantName + "\"";
    }

    public static Object determineValue(FlowExpression expression, InFlowWorkItem workItem) throws ValueException {
        return ValueUtils.determineValue("", expression, workItem);
    }

    public static Attribute determineWorkitemFragment(FlowExpression expression, InFlowWorkItem workitem) throws ValueException {
        String sContent = expression.lookupAttribute("__content__", workitem);
        if (sContent == null) {
            return null;
        }
        try {
            Element eContent = XmlUtils.extractXmlElement((String)sContent);
            eContent = XmlUtils.getFirstChild((Element)eContent);
            if (eContent == null) {
                return null;
            }
            return Definitions.getXmlCoder(expression.context()).decodeAttribute(eContent);
        }
        catch (Exception e) {
            throw new ValueException("Failed to extract workitem fragment", e);
        }
    }

    public static Object determineValue(String prefix, FlowExpression expression, InFlowWorkItem workItem) throws ValueException {
        String value = expression.lookupAttribute(prefix + VALUE, workItem);
        String valueFieldName = expression.lookupAttribute(prefix + FIELD_VALUE, workItem);
        String valueVariableName = expression.lookupAttribute(prefix + VARIABLE_VALUE, workItem);
        if (value == null && prefix.equals("") && (value = expression.lookupAttribute("__value__", workItem)) == null && expression.getAttributes().containsKey("__content__")) {
            return ValueUtils.determineWorkitemFragment(expression, workItem);
        }
        String functionValue = expression.lookupAttribute(prefix + FUNCTION_VALUE, workItem);
        if (functionValue != null) {
            functionValue = ValueUtils.executeFunction(expression, workItem, functionValue);
        }
        if (value == null && valueFieldName == null && valueVariableName == null && functionValue == null) {
            throw new ValueException("There is no attribute '" + prefix + VALUE + "', '" + prefix + FIELD_VALUE + "' or '" + prefix + VARIABLE_VALUE + "' or '" + prefix + FUNCTION_VALUE + "'. Cannot determine value");
        }
        Object variableValue = null;
        if (value != null) {
            variableValue = value;
            String type = expression.lookupAttribute(TYPE, workItem);
            if (type != null) {
                if (type.equals(T_BOOLEAN)) {
                    variableValue = new BooleanAttribute(value);
                } else if (type.equals(T_INTEGER)) {
                    variableValue = new IntegerAttribute(value);
                } else if (type.equals(T_LONG)) {
                    variableValue = new LongAttribute(value);
                } else if (type.equals(T_DOUBLE)) {
                    variableValue = new DoubleAttribute(value);
                }
            }
        } else if (valueVariableName != null) {
            variableValue = expression.lookupVariable(valueVariableName);
        } else if (valueFieldName != null) {
            Attribute fv0 = workItem.getAttribute(valueFieldName);
            String fv1 = ((AbstractFlowExpression)expression).substituteText("${f:" + valueFieldName + "}", workItem);
            if (fv0 != null) {
                variableValue = fv0;
            } else if (fv1 != null && fv1.length() > 0) {
                variableValue = fv1;
            }
        } else if (functionValue != null) {
            variableValue = functionValue;
        }
        return variableValue;
    }

    public static Map determineAndSetTarget(FlowExpression expression, InFlowWorkItem workItem, Object value) throws ValueException {
        return ValueUtils.doDetermineAndSetTarget("", expression, workItem, value);
    }

    public static Map determineAndSetTarget(String prefix, FlowExpression expression, InFlowWorkItem workItem, Object value) throws ValueException {
        return ValueUtils.doDetermineAndSetTarget(prefix, expression, workItem, value);
    }

    private static Map doDetermineAndSetTarget(String prefix, FlowExpression expression, InFlowWorkItem workItem, Object value) throws ValueException {
        Attribute currentValue;
        if (prefix == null) {
            prefix = "";
        }
        String fieldName = expression.lookupAttribute(prefix + FIELD_TARGET, workItem);
        String variableName = expression.lookupAttribute(prefix + VARIABLE_TARGET, workItem);
        if (fieldName == null && variableName == null) {
            throw new ValueException("Expression should set a value but which one ? there is no paremeter '" + prefix + FIELD_TARGET + "' or '" + prefix + VARIABLE_TARGET + "' given.");
        }
        if (variableName != null) {
            ValueUtils.setVariable(expression, variableName, value);
            HashMap<String, Object> result = new HashMap<String, Object>(1);
            result.put(variableName, value);
            return result;
        }
        boolean override = true;
        String sOverride = expression.lookupAttribute(OVERRIDE, workItem);
        if (sOverride != null && sOverride.trim().toLowerCase().equals("false")) {
            override = false;
        }
        if ((currentValue = workItem.getAttributes().getField(fieldName)) != null && !override) {
            return null;
        }
        workItem.getAttributes().setField(fieldName, value);
        return null;
    }

    public static void determineAndIncrementTarget(FlowExpression expression, InFlowWorkItem workItem, Object value) throws ValueException {
        if (value == null) {
            return;
        }
        String fieldName = expression.lookupAttribute(FIELD_TARGET, workItem);
        String variableName = expression.lookupAttribute(VARIABLE_TARGET, workItem);
        if (fieldName == null && variableName == null) {
            throw new ValueException("Expression should set a value but which one ? there is no paremeter 'field' or 'variable' given.");
        }
        if (variableName != null) {
            Object currentValue = expression.lookupVariable(variableName);
            value = ValueUtils.increment(currentValue, value);
            ValueUtils.setVariable(expression, variableName, value);
        } else if (fieldName != null) {
            Attribute currentValue = workItem.getAttributes().get(fieldName);
            value = ValueUtils.increment(currentValue, value);
            value = AttributeUtils.java2owfe(value);
            workItem.getAttributes().put(fieldName, (Attribute)value);
        }
    }

    private static void setVariable(FlowExpression expression, String variableName, Object value) {
        String vName = variableName;
        FlowExpression containingExpression = null;
        if (variableName.startsWith("./")) {
            containingExpression = expression;
            vName = variableName.substring(2);
        } else {
            containingExpression = expression.getExpressionPool().lookupContainingEnvironment(expression, vName);
            if (containingExpression == null) {
                containingExpression = expression;
            }
        }
        expression.getExpressionPool().setVariable(containingExpression, vName, value);
    }

    private static Object increment(Object val, Object inc) {
        Object originalVal = val;
        val = ValueUtils.refineValue(val);
        inc = ValueUtils.refineValue(inc);
        Object result = ValueUtils.refinedIncrement(val, inc);
        if (originalVal instanceof Attribute) {
            if (result instanceof Long) {
                return new LongAttribute((Long)result);
            }
            if (result instanceof Double) {
                return new DoubleAttribute((Double)result);
            }
            return new StringAttribute(result.toString());
        }
        return result;
    }

    private static Object refineValue(Object o) {
        if (o == null) {
            return "";
        }
        try {
            long l = Long.parseLong(o.toString());
            return new Long(l);
        }
        catch (NumberFormatException nfe) {
            try {
                double d = Double.parseDouble(o.toString());
                return new Double(d);
            }
            catch (NumberFormatException numberFormatException) {
                return o.toString();
            }
        }
    }

    private static double toDouble(Object o) {
        return Double.parseDouble(o.toString());
    }

    private static int toInt(Object o) {
        return Integer.parseInt(o.toString());
    }

    private static Object refinedIncrement(Object val, Object inc) {
        if (val instanceof String || inc instanceof String) {
            return val.toString() + inc.toString();
        }
        if (val instanceof Double || inc instanceof Double) {
            return new Double(ValueUtils.toDouble(val) + ValueUtils.toDouble(inc));
        }
        return new Integer(ValueUtils.toInt(val) + ValueUtils.toInt(inc));
    }

    public static boolean lookupBooleanResult(InFlowWorkItem wi) throws ReplyException {
        Attribute a = wi.getAttributes().get(F_RESULT);
        if (a == null) {
            throw new ReplyException("lookupBooleanVariable() no boolean result found");
        }
        if (a instanceof BooleanAttribute) {
            return ((BooleanAttribute)a).booleanValue();
        }
        return a.toString().toLowerCase().equals("true");
    }

    public static void cleanResult(InFlowWorkItem wi) {
        wi.getAttributes().remove(F_RESULT);
    }

    public static void setBooleanResult(InFlowWorkItem wi, boolean result) {
        wi.getAttributes().put(F_RESULT, (Attribute)new BooleanAttribute(result));
    }

    public static void setBooleanResult(InFlowWorkItem wi, Boolean result) {
        ValueUtils.setBooleanResult(wi, (boolean)result);
    }

    public static void setResult(InFlowWorkItem wi, Object result) {
        wi.getAttributes().put(F_RESULT, AttributeUtils.java2owfe(result));
    }

    public static Attribute getResult(InFlowWorkItem wi) {
        return wi.getAttributes().get(F_RESULT);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

