/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.misc.Text;

public class VariableMap
extends AbstractMap {
    public static final String FIELD_PREFIX = "field:";
    public static final String FIELD_PREFIX_2 = "f:";
    public static final String VAR_PREFIX = "v:";
    public static final String VAR_PREFIX_2 = "var:";
    public static final String VAR_PREFIX_3 = "variable:";
    public static final String FV_PREFIX = "fv:";
    public static final String VF_PREFIX = "vf:";
    public static final String CALL_PREFIX = "call:";
    public static final String CALL_PREFIX_2 = "c:";
    public static final String CONST_PREFIX = "const:";
    private Map map = null;
    private FlowExpression flowExpression = null;
    private InFlowWorkItem workitem = null;

    public VariableMap(FlowExpression fe, InFlowWorkItem wi) {
        this(null, fe, wi);
    }

    public VariableMap(Map m, FlowExpression fe, InFlowWorkItem wi) {
        this.map = m;
        this.flowExpression = fe;
        this.workitem = wi;
    }

    public Set entrySet() {
        return null;
    }

    public boolean containsKey(Object o) {
        return this.get(o) != null;
    }

    public Object get(Object o) {
        String rawKey = o.toString();
        String[] spk = this.determinePrefixAndKey(o);
        String prefix = spk[0];
        String key = spk[1];
        if (prefix == null) {
            return this.lookupVariableValue(key);
        }
        if (prefix.equals(CALL_PREFIX)) {
            return ValueUtils.executeFunction(this.flowExpression, this.workitem, key);
        }
        if (prefix.equals(CONST_PREFIX)) {
            return ValueUtils.lookupConstant(key);
        }
        if (prefix.equals(FIELD_PREFIX)) {
            return this.lookupFieldValue(key);
        }
        if (prefix.equals(FV_PREFIX)) {
            String fieldValue = this.lookupFieldValue(key);
            if (fieldValue != null) {
                return fieldValue;
            }
            return this.lookupVariableValue(key);
        }
        if (prefix.equals(VF_PREFIX)) {
            String varValue = this.lookupVariableValue(key);
            if (varValue != null) {
                return varValue;
            }
            return this.lookupFieldValue(key);
        }
        return null;
    }

    public void setFlowExpression(FlowExpression fe) {
        this.flowExpression = fe;
    }

    private String matchesPrefix(String rawKey, String prefix) {
        if (rawKey.startsWith(prefix)) {
            return rawKey.substring(prefix.length());
        }
        return null;
    }

    private String[] determinePrefixAndKey(Object o) {
        String rawKey = o.toString();
        String key = null;
        key = this.matchesPrefix(rawKey, CALL_PREFIX);
        if (key != null) {
            return new String[]{CALL_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, CALL_PREFIX_2);
        if (key != null) {
            return new String[]{CALL_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, FIELD_PREFIX);
        if (key != null) {
            return new String[]{FIELD_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, FIELD_PREFIX_2);
        if (key != null) {
            return new String[]{FIELD_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, CONST_PREFIX);
        if (key != null) {
            return new String[]{CONST_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, FV_PREFIX);
        if (key != null) {
            return new String[]{FV_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, VF_PREFIX);
        if (key != null) {
            return new String[]{VF_PREFIX, key};
        }
        key = this.matchesPrefix(rawKey, VAR_PREFIX);
        if (key != null) {
            return new String[]{null, key};
        }
        key = this.matchesPrefix(rawKey, VAR_PREFIX_2);
        if (key != null) {
            return new String[]{null, key};
        }
        key = this.matchesPrefix(rawKey, VAR_PREFIX_3);
        if (key != null) {
            return new String[]{null, key};
        }
        return new String[]{null, rawKey};
    }

    private String lookupFieldValue(String key) {
        if (this.workitem == null) {
            return null;
        }
        Attribute a = CollectionAttribute.lookupAttribute(key, this.workitem.getAttributes());
        if (a == null) {
            return null;
        }
        return a.toString();
    }

    private String lookupVariableValue(String key) {
        Object value = null;
        if (this.map != null) {
            value = this.map.get(key);
        }
        if (value != null) {
            return value.toString();
        }
        if (this.flowExpression != null) {
            value = this.flowExpression.lookupVariable(key);
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String substitute(FlowExpression fe, InFlowWorkItem wi, String text) {
        if (text.indexOf("${") < 0) {
            return text;
        }
        return Text.substitute((String)text, (Map)new VariableMap(fe, wi));
    }
}

