/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlExpressionMap
extends AbstractService
implements ExpressionMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$map$XmlExpressionMap == null ? (class$openwfe$org$engine$expressions$map$XmlExpressionMap = XmlExpressionMap.class$("openwfe.org.engine.expressions.map.XmlExpressionMap")) : class$openwfe$org$engine$expressions$map$XmlExpressionMap).getName());
    public static final String RAW_KEY = "__raw__";
    public static final String P_EXPRESSION_MAP_FILE = "expressionMapFile";
    private String processDefinitionExpressionName = null;
    private Map map = new HashMap();
    static /* synthetic */ Class class$openwfe$org$engine$expressions$map$XmlExpressionMap;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$DefineExpression;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ParticipantExpression;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String fileName = Utils.expandUrl((String)context.getApplicationDirectory(), (String)((String)this.getParams().get(P_EXPRESSION_MAP_FILE)));
        try {
            this.build(XmlUtils.extractXml((String)fileName, (boolean)false));
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XmlExpressionMap from file '" + fileName + "'", (Throwable)e);
        }
    }

    private void build(Element rootElt) {
        List children = rootElt.getChildren("expression");
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            String expressionName = child.getAttributeValue("name").trim();
            String className = child.getAttributeValue("class").trim();
            Map params = Parameters.extractParameters((Element)child);
            try {
                Class<?> expressionClass = Class.forName(className);
                Entry e = new Entry(expressionName, expressionClass);
                log.info((Object)("loaded expression '" + expressionName + "', class is " + className));
                this.map.put(expressionName, e);
                if (this.processDefinitionExpressionName != null || !expressionClass.equals(class$openwfe$org$engine$expressions$DefineExpression == null ? XmlExpressionMap.class$("openwfe.org.engine.expressions.DefineExpression") : class$openwfe$org$engine$expressions$DefineExpression)) continue;
                this.processDefinitionExpressionName = expressionName;
            }
            catch (ClassNotFoundException cnfe) {
                log.info((Object)("Class '" + className + "' for expression '" + expressionName + "' not found."), (Throwable)cnfe);
            }
        }
    }

    public Class getRawExpressionClass() {
        return this.getClass(RAW_KEY);
    }

    public FlowExpression instantiateExpression(String expressionName) throws BuildException {
        Class expressionClass = this.getClass(expressionName);
        if (expressionClass == null) {
            throw new BuildException("Unmapped expression '" + expressionName + "'");
        }
        FlowExpression fe = null;
        try {
            fe = (FlowExpression)expressionClass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Failed to build expression '" + expressionName + "' with class '" + expressionClass.getName() + "'", e);
        }
        return fe;
    }

    public Class getClass(String expressionName) {
        Entry e = (Entry)this.map.get(expressionName);
        if (e == null) {
            return null;
        }
        return e.expressionClass;
    }

    public String getName(Class expressionClass) {
        if (expressionClass.equals(class$openwfe$org$engine$expressions$DefineExpression == null ? (class$openwfe$org$engine$expressions$DefineExpression = XmlExpressionMap.class$("openwfe.org.engine.expressions.DefineExpression")) : class$openwfe$org$engine$expressions$DefineExpression)) {
            return this.processDefinitionExpressionName;
        }
        if (expressionClass.equals(class$openwfe$org$engine$expressions$ParticipantExpression == null ? (class$openwfe$org$engine$expressions$ParticipantExpression = XmlExpressionMap.class$("openwfe.org.engine.expressions.ParticipantExpression")) : class$openwfe$org$engine$expressions$ParticipantExpression)) {
            return "participant";
        }
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Entry e = (Entry)this.map.get(name);
            if (!e.expressionClass.equals(expressionClass)) continue;
            return name;
        }
        return null;
    }

    public String[] getNames(Class expressionClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNames() for class " + expressionClass.getName()));
        }
        ArrayList<String> result = new ArrayList<String>(this.map.size());
        Iterator<Object> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Entry e = (Entry)this.map.get(name);
            if (!expressionClass.isAssignableFrom(e.expressionClass)) continue;
            result.add(e.shortName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getNames()   - '" + e.shortName + "'"));
        }
        String[] sResult = new String[result.size()];
        int i = 0;
        it = result.iterator();
        while (it.hasNext()) {
            sResult[i] = (String)it.next();
            ++i;
        }
        return sResult;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Entry {
        public String shortName = null;
        public Class expressionClass = null;

        public Entry(String shortName, Class expressionClass) {
            this.shortName = shortName;
            this.expressionClass = expressionClass;
        }
    }
}

