/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.raw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class RawExpression
extends ZeroChildExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$raw$RawExpression == null ? (class$openwfe$org$engine$expressions$raw$RawExpression = RawExpression.class$("openwfe.org.engine.expressions.raw.RawExpression")) : class$openwfe$org$engine$expressions$raw$RawExpression).getName());
    private static long lastGivenInstanceId = -1L;
    private transient ProcessDefinition processDefinition = null;
    private transient FlowExpression generatedExpression = null;
    private int subId = 0;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$raw$RawExpression;

    public int getSubId() {
        return this.subId;
    }

    public void setSubId(int i) {
        this.subId = i;
    }

    public abstract void init(ApplicationContext var1, FlowExpressionId var2, FlowExpressionId var3, int var4, Object var5) throws BuildException;

    public abstract void init(ApplicationContext var1, FlowExpressionId var2, FlowExpressionId var3, FlowExpressionId var4, Object var5) throws BuildException;

    public abstract boolean isDefinition();

    public abstract boolean isWorkflowDefinition();

    public abstract String getDefinitionName();

    public abstract FlowExpression resolveExpression(InFlowWorkItem var1) throws BuildException;

    public abstract FlowExpression resolveExpression(ProcessDefinition var1) throws BuildException;

    public abstract List prepareChildren(InFlowWorkItem var1) throws BuildException;

    public abstract Object getRaw();

    public List cleanChildren(List children) {
        ArrayList result = new ArrayList(children.size());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof FlowExpressionId)) continue;
            result.add(o);
        }
        return result;
    }

    protected synchronized String nextSubId() {
        String result = "" + this.subId;
        ++this.subId;
        return result;
    }

    protected FlowExpressionId determineId(FlowExpressionId parentId, String expressionName, int expressionId) {
        FlowExpressionId newId = parentId.copy();
        newId.setExpressionName(expressionName);
        String parentExpressionId = parentId.getExpressionId();
        if (parentExpressionId == null) {
            newId.setExpressionId("" + expressionId);
        } else {
            newId.setExpressionId(parentExpressionId + "." + expressionId);
        }
        return newId;
    }

    public synchronized RawExpression newInstance(FlowExpressionId parentId) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"newInstance()");
            log.debug((Object)("newInstance() this.id   " + this.getId()));
            log.debug((Object)("newInstance() parentId  " + parentId));
        }
        RawExpression clone = (RawExpression)this.clone();
        String oldId = clone.getId().getWorkflowInstanceId();
        String newWfid = null;
        if (parentId != null) {
            String parentRoot;
            String oldRoot = FlowExpressionId.extractParentWorkflowInstanceId(oldId);
            if (!oldRoot.equals(parentRoot = parentId.getParentWorkflowInstanceId())) {
                newWfid = oldId;
            }
        } else if (oldId.indexOf(".") < 0 && clone.getId().getExpressionId().equals("0")) {
            newWfid = oldId;
        }
        if (newWfid == null) {
            newWfid = oldId + "." + this.nextSubId();
        }
        clone.getId().setWorkflowInstanceId(newWfid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("newInstance() clone.wfid   = " + newWfid));
            log.debug((Object)("newInstance() clone.id     = " + clone.getId()));
            log.debug((Object)("newInstance() clone.parent = " + clone.getParent()));
        }
        this.getExpressionPool().add(clone);
        this.storeItself();
        return clone;
    }

    public FlowExpression preApply(InFlowWorkItem wi) throws ApplyException {
        try {
            FlowExpression realExpression = this.resolveExpression(wi);
            Definitions.getExpressionPool(this.context()).add(realExpression);
            return realExpression;
        }
        catch (Throwable t) {
            throw new ApplyException("preApply failed", t);
        }
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        FlowExpression realExpression = this.preApply(wi);
        realExpression.apply(wi);
    }

    public void launch(InFlowWorkItem wi) throws ApplyException {
        FlowExpression realExpression = this.preApply(wi);
        realExpression.launch(wi);
    }

    public final void reply(InFlowWorkItem wi) throws ReplyException {
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition def) {
        this.processDefinition = def;
    }

    public FlowExpression getGeneratedExpression() {
        return this.generatedExpression;
    }

    public void setGeneratedExpression(FlowExpression fe) {
        this.generatedExpression = fe;
    }

    public static synchronized String determineNewWorkflowInstanceId() {
        long instanceId;
        for (instanceId = System.currentTimeMillis(); instanceId <= lastGivenInstanceId; ++instanceId) {
        }
        lastGivenInstanceId = instanceId;
        return "" + instanceId;
    }

    public static RawExpression getEmptyRawExpression(ApplicationContext context) {
        ExpressionMap expMap = Definitions.getExpressionMap(context);
        return (RawExpression)ReflectionUtils.buildNewInstance((String)expMap.getRawExpressionClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

