/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.sync.ClassicalSyncExpression;
import openwfe.org.engine.expressions.sync.MergeUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class GenericSyncExpression
extends ClassicalSyncExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$sync$GenericSyncExpression == null ? (class$openwfe$org$engine$expressions$sync$GenericSyncExpression = GenericSyncExpression.class$("openwfe.org.engine.expressions.sync.GenericSyncExpression")) : class$openwfe$org$engine$expressions$sync$GenericSyncExpression).getName());
    public static final String A_SYNC = "sync";
    public static final String A_COUNT = "count";
    public static final String A_MERGE = "merge";
    public static final String A_MERGE_TYPE = "merge-type";
    public static final String A_REMAINING = "remaining";
    public static final String MG_FIRST = "first";
    public static final String MG_LAST = "last";
    public static final String MG_HIGHEST = "highest";
    public static final String MG_LOWEST = "lowest";
    public static final String DEFAULT_MG = "first";
    public static final String MT_MIX = "mix";
    public static final String MT_OVERRIDE = "override";
    public static final String DEFAULT_MT = "mix";
    public static final String REM_CANCEL = "cancel";
    public static final String REM_FORGET = "forget";
    public static final String DEFAULT_REM = "cancel";
    private int count = -1;
    private String merge = null;
    private String mergeType = null;
    private String remaining = null;
    private List childrenAltitudes = null;
    private int replyCount = 0;
    private InFlowWorkItem overridenWorkitem = null;
    private List incomingWorkitems = null;
    private List unreadyQueue = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$sync$GenericSyncExpression;

    public void init(SynchableExpression se, List childList, InFlowWorkItem wi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() on behalf of " + se.getId()));
        }
        String sCount = se.lookupAttribute(A_COUNT, wi);
        try {
            this.count = Integer.parseInt(sCount);
        }
        catch (Exception e) {
            this.count = -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() count : " + this.count));
        }
        this.merge = se.lookupAttribute(A_MERGE, wi);
        if (!("first".equals(this.merge) || MG_LAST.equals(this.merge) || MG_HIGHEST.equals(this.merge) || MG_LOWEST.equals(this.merge))) {
            this.merge = "first";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() merge : '" + this.merge + "'"));
        }
        this.mergeType = se.lookupAttribute(A_MERGE_TYPE, wi);
        if (!"mix".equals(this.mergeType) && !MT_OVERRIDE.equals(this.mergeType)) {
            this.mergeType = "mix";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() merge : '" + this.mergeType + "'"));
        }
        this.remaining = se.lookupAttribute(A_REMAINING, wi);
        if (!"cancel".equals(this.remaining) && !REM_FORGET.equals(this.remaining)) {
            this.remaining = "cancel";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() remaining : '" + this.remaining + "'"));
        }
        if (childList == null) {
            this.incomingWorkitems = new LinkedList();
            this.unreadyQueue = new LinkedList();
        } else {
            this.incomingWorkitems = new ArrayList(childList.size());
            this.unreadyQueue = new ArrayList(childList.size());
        }
        if (this.merge.equals(MG_LAST) || this.merge.equals("first")) {
            return;
        }
        this.childrenAltitudes = this.listAltitudes(childList);
    }

    private List listAltitudes(List childList) {
        if (childList == null) {
            return new LinkedList();
        }
        ArrayList<FlowExpressionId> result = new ArrayList<FlowExpressionId>(childList.size());
        Iterator it = childList.iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            result.add(fei);
        }
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public String getMerge() {
        return this.merge;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public String getRemaining() {
        return this.remaining;
    }

    public void setCount(int i) {
        this.count = i;
    }

    public void setMerge(String s) {
        this.merge = s;
    }

    public void setMergeType(String s) {
        this.mergeType = s;
    }

    public void setRemaining(String s) {
        this.remaining = s;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    public InFlowWorkItem getOverridenWorkitem() {
        return this.overridenWorkitem;
    }

    public List getIncomingWorkitems() {
        return this.incomingWorkitems;
    }

    public List getChildrenAltitudes() {
        return this.childrenAltitudes;
    }

    public List getUnreadyQueue() {
        return this.unreadyQueue;
    }

    public void setReplyCount(int i) {
        this.replyCount = i;
    }

    public void setOverridenWorkitem(InFlowWorkItem wi) {
        this.overridenWorkitem = wi;
    }

    public void setIncomingWorkitems(List l) {
        this.incomingWorkitems = l;
    }

    public void setChildrenAltitudes(List l) {
        this.childrenAltitudes = l;
    }

    public void setUnreadyQueue(List l) {
        this.unreadyQueue = l;
    }

    public synchronized void ready(SynchableExpression se) throws ReplyException {
        if (this.unreadyQueue != null) {
            List queue = this.unreadyQueue;
            this.unreadyQueue = null;
            se.storeItself();
            Iterator it = queue.iterator();
            while (it.hasNext()) {
                InFlowWorkItem wi = (InFlowWorkItem)it.next();
                this.reply(se, wi);
            }
        }
    }

    public void addChild(FlowExpressionId fei) {
        super.addChild(fei);
        if (this.childrenAltitudes != null) {
            this.childrenAltitudes.add(fei.getWorkflowInstanceId());
        }
    }

    private void removeChild(FlowExpressionId fei) {
        boolean removed = this.getChildren().remove(fei);
        if (removed) {
            log.debug((Object)"removeChild() removed (fei)");
            return;
        }
        FlowExpressionId toRemove = null;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId child = (FlowExpressionId)it.next();
            if (!child.getWorkflowInstanceId().equals(fei.getWorkflowInstanceId())) continue;
            toRemove = child;
            break;
        }
        if (toRemove != null) {
            log.debug((Object)"removeChild() removed (wfid)");
            this.getChildren().remove(toRemove);
        }
    }

    public synchronized void reply(SynchableExpression se, InFlowWorkItem wi) throws ReplyException {
        if (this.unreadyQueue != null) {
            log.debug((Object)"reply() sync expression not ready : queueing reply");
            this.unreadyQueue.add(wi.clone());
            se.storeItself();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() from " + wi.getLastExpressionId()));
        }
        int childCount = this.getChildren().size();
        boolean syncIsOver = false;
        this.receiveWorkitem(wi);
        this.removeChild(wi.getLastExpressionId());
        syncIsOver = syncIsOver || this.getChildren().size() < 1;
        boolean bl = syncIsOver = syncIsOver || this.getCount() > 0 && this.replyCount >= this.count;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() delta is " + (childCount - this.getChildren().size())));
            log.debug((Object)("reply() is sync over for " + se.getId() + " ? " + syncIsOver));
        }
        if (syncIsOver) {
            this.terminateSync(se);
            return;
        }
        se.storeItself();
    }

    private void receiveWorkitem(InFlowWorkItem wi) {
        ++this.replyCount;
        if (this.getMergeType().equals("mix")) {
            if (this.getMerge().equals(MG_HIGHEST) || this.getMerge().equals(MG_LOWEST)) {
                this.getIncomingWorkitems().add(wi.clone());
                return;
            }
            if (this.overridenWorkitem == null) {
                this.overridenWorkitem = (InFlowWorkItem)wi.clone();
                return;
            }
            if (this.getMerge().equals("first")) {
                this.overridenWorkitem = MergeUtils.merge(wi, this.overridenWorkitem);
                return;
            }
            this.overridenWorkitem = MergeUtils.merge(this.overridenWorkitem, wi);
            return;
        }
        if (this.overridenWorkitem == null) {
            this.overridenWorkitem = (InFlowWorkItem)wi.clone();
            return;
        }
        if (this.getMerge().equals("first")) {
            if (this.overridenWorkitem != null) {
                return;
            }
            this.overridenWorkitem = (InFlowWorkItem)wi.clone();
            return;
        }
        if (this.getMerge().equals(MG_LAST)) {
            this.overridenWorkitem = (InFlowWorkItem)wi.clone();
            return;
        }
        int currentAltitude = this.determineAltitude(this.overridenWorkitem);
        int incomingAltitude = this.determineAltitude(wi);
        if (incomingAltitude < 0) {
            throw new IllegalArgumentException("Not waiting on the incoming workitem");
        }
        if (this.getMerge().equals(MG_HIGHEST)) {
            if (incomingAltitude < currentAltitude) {
                this.overridenWorkitem = (InFlowWorkItem)wi.clone();
            }
        } else if (incomingAltitude > currentAltitude) {
            this.overridenWorkitem = (InFlowWorkItem)wi.clone();
        }
    }

    private int determineAltitude(InFlowWorkItem wi) {
        String wfiid = wi.getLastExpressionId().getWorkflowInstanceId();
        return this.getChildrenAltitudes().indexOf(wfiid);
    }

    private void terminateSync(SynchableExpression se) throws ReplyException {
        try {
            this.treatRemainingChildren(se);
        }
        catch (ApplyException ae) {
            log.warn((Object)("Failed to '" + this.getRemaining() + "' remaining children"), (Throwable)((Object)ae));
            throw new ReplyException("Failed to '" + this.getRemaining() + "' remaining children", (Throwable)((Object)ae));
        }
        InFlowWorkItem resultingWorkitem = null;
        if (this.overridenWorkitem != null) {
            resultingWorkitem = this.overridenWorkitem;
        } else {
            Collections.sort(this.getChildrenAltitudes());
            if (this.getMerge().equals(MG_HIGHEST)) {
                Collections.reverse(this.getChildrenAltitudes());
            }
            Map answerMap = this.determineAnswerMap();
            Iterator it = this.getChildrenAltitudes().iterator();
            while (it.hasNext()) {
                String wfiid = (String)it.next();
                InFlowWorkItem workitem = (InFlowWorkItem)answerMap.get(wfiid);
                if (workitem == null) continue;
                resultingWorkitem = MergeUtils.merge(resultingWorkitem, workitem);
            }
        }
        if (resultingWorkitem == null) {
            log.warn((Object)"reply() resultingWorkitem is null");
        }
        se.replyToParent(resultingWorkitem);
    }

    private Map determineAnswerMap() {
        HashMap<String, InFlowWorkItem> result = new HashMap<String, InFlowWorkItem>(this.getIncomingWorkitems().size());
        Iterator it = this.getIncomingWorkitems().iterator();
        while (it.hasNext()) {
            InFlowWorkItem wi = (InFlowWorkItem)it.next();
            result.put(wi.getLastExpressionId().getWorkflowInstanceId(), wi);
        }
        return result;
    }

    private void treatRemainingChildren(SynchableExpression se) throws ApplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("treatRemainingChildren() - " + this.getChildren().size() + " children in total"));
        }
        ArrayList<FlowExpressionId> alreadyReplied = new ArrayList<FlowExpressionId>(this.getIncomingWorkitems().size());
        Iterator it = this.getIncomingWorkitems().iterator();
        while (it.hasNext()) {
            InFlowWorkItem wi = (InFlowWorkItem)it.next();
            alreadyReplied.add(wi.getLastExpressionId());
        }
        it = this.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            if (alreadyReplied.contains(fei)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("treatRemainingChildren() '" + this.getRemaining() + "' on " + fei));
            }
            if ("cancel".equals(this.getRemaining())) {
                se.getExpressionPool().childCancel(fei);
                continue;
            }
            se.getExpressionPool().forget(fei);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

