/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.functions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.functions.FunctionMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class AbstractFunctionMap
extends AbstractService
implements FunctionMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$functions$AbstractFunctionMap == null ? (class$openwfe$org$engine$functions$AbstractFunctionMap = AbstractFunctionMap.class$("openwfe.org.engine.functions.AbstractFunctionMap")) : class$openwfe$org$engine$functions$AbstractFunctionMap).getName());
    private static final Class[] FUNCTION_ARG_TYPES = new Class[]{class$openwfe$org$engine$expressions$FlowExpression == null ? (class$openwfe$org$engine$expressions$FlowExpression = AbstractFunctionMap.class$("openwfe.org.engine.expressions.FlowExpression")) : class$openwfe$org$engine$expressions$FlowExpression, class$openwfe$org$engine$workitem$InFlowWorkItem == null ? (class$openwfe$org$engine$workitem$InFlowWorkItem = AbstractFunctionMap.class$("openwfe.org.engine.workitem.InFlowWorkItem")) : class$openwfe$org$engine$workitem$InFlowWorkItem, array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractFunctionMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private List classes = null;
    private Map functionMap = null;
    static /* synthetic */ Class class$openwfe$org$engine$functions$AbstractFunctionMap;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$FlowExpression;
    static /* synthetic */ Class class$openwfe$org$engine$workitem$InFlowWorkItem;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.buildMap();
    }

    protected List getClasses() {
        return this.classes;
    }

    protected Map getFunctionMap() {
        return this.functionMap;
    }

    protected void setClasses(List l) {
        this.classes = l;
    }

    protected void setFunctionMap(Map m) {
        this.functionMap = m;
    }

    private Class findClass(String functionName) {
        Iterator it = this.classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            try {
                Method m = clazz.getMethod(functionName, FUNCTION_ARG_TYPES);
                return clazz;
            }
            catch (Throwable t) {
                log.debug((Object)("findClass() did not find class for function named '" + functionName + "' in class '" + clazz.getName() + "'"));
            }
        }
        return null;
    }

    public String eval(String functionName, FlowExpression fe, InFlowWorkItem wi, String[] args) {
        Class clazz = (Class)this.functionMap.get(functionName);
        if (clazz == null) {
            clazz = this.findClass(functionName);
            if (clazz == null) {
                log.info((Object)("eval() did not find any class for function '" + functionName + "'"));
                return "(unknown function '" + functionName + "')";
            }
            this.functionMap.put(functionName, clazz);
        }
        Throwable t = null;
        try {
            return (String)ReflectionUtils.invokeStatic((Class)clazz, (String)functionName, (Class[])FUNCTION_ARG_TYPES, (Object[])new Object[]{fe, wi, args});
        }
        catch (InvocationTargetException ite) {
            t = ite.getCause();
        }
        catch (Throwable tt) {
            t = tt;
        }
        log.warn((Object)("eval() failed for '" + functionName + "' at " + fe.getId()), t);
        wi.getAttributes().puts("__function_error__", t.toString());
        return "";
    }

    protected abstract void buildMap() throws ServiceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

