/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.dispatch;

import java.util.Map;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;

public class SmtpDispatcher
extends AbstractWorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$dispatch$SmtpDispatcher == null ? (class$openwfe$org$engine$impl$dispatch$SmtpDispatcher = SmtpDispatcher.class$("openwfe.org.engine.impl.dispatch.SmtpDispatcher")) : class$openwfe$org$engine$impl$dispatch$SmtpDispatcher).getName());
    public static final String P_RECIPIENT = "recipient";
    public static final String P_RECIPIENT_FIELD = "recipient-field";
    public static final String P_CC = "cc";
    public static final String SUBJECT_PREFIX = "openwfe.workitem::";
    private String recipient = null;
    private String recipientField = null;
    private String cc = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$dispatch$SmtpDispatcher;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.recipient = MapUtils.getAsString((Map)serviceParams, (String)P_RECIPIENT);
        this.recipientField = MapUtils.getAsString((Map)serviceParams, (String)P_RECIPIENT_FIELD);
        this.cc = MapUtils.getAsString((Map)serviceParams, (String)P_CC);
    }

    public Object dispatch(WorkItem wi) throws DispatchingException {
        try {
            String s;
            Session mailSession = MailUtils.getMailSession((Map)this.getParams());
            MimeMessage m = new MimeMessage(mailSession);
            MailUtils.setMailFrom((Message)m, (Map)this.getParams());
            String sRecipient = this.recipient;
            if (this.recipientField != null && (s = wi.getAttributes().sget(this.recipientField)) != null) {
                sRecipient = s;
            }
            if (sRecipient == null) {
                throw new DispatchingException("Cannot dispatch to 'null' recipient");
            }
            MailUtils.addRecipients((Message)m, (Message.RecipientType)Message.RecipientType.TO, (String)sRecipient);
            MailUtils.addRecipients((Message)m, (Message.RecipientType)Message.RecipientType.CC, (String)this.cc);
            m.setSubject(this.determineSubject(wi));
            byte[] payload = (byte[])this.instantiateEncoder().encode(wi, this.getContext(), this.getParams());
            StringBuffer sb = new StringBuffer();
            sb.append(this.getWorkItemCoderName()).append("\n").append(new String(payload, Utils.getEncoding()));
            m.setText(sb.toString(), Utils.getEncoding());
            mailSession.getTransport("smtp");
            Transport.send((Message)m);
            log.debug((Object)("dispatch() mail sent to '" + sRecipient + "'"));
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to dispatch workitem over SMTP", t);
            throw new DispatchingException("Failed to dispatch workitem over SMTP", t);
        }
        return null;
    }

    protected String determineSubject(WorkItem wi) {
        String subject = SUBJECT_PREFIX + wi.getClass().getName();
        if (wi instanceof InFlowWorkItem) {
            InFlowWorkItem ifwi = (InFlowWorkItem)wi;
            FlowExpressionId id = ifwi.getLastExpressionId();
            StringBuffer sb = new StringBuffer();
            sb.append(SUBJECT_PREFIX).append(id.getEngineId()).append(":").append(id.getWorkflowInstanceId()).append(":").append(id.getExpressionId());
            subject = sb.toString();
        }
        return subject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

