/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.AbstractExpressionStore;
import openwfe.org.engine.impl.expool.ExpoolUtils;
import openwfe.org.misc.DirectoryFilter;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public abstract class FileExpressionStore
extends AbstractExpressionStore {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$FileExpressionStore == null ? (class$openwfe$org$engine$impl$expool$FileExpressionStore = FileExpressionStore.class$("openwfe.org.engine.impl.expool.FileExpressionStore")) : class$openwfe$org$engine$impl$expool$FileExpressionStore).getName());
    public static String P_WORK_DIRECTORY = "workDirectory";
    public static final String DEFAULT_WORK_DIRECTORY = "work/engine/pool";
    private String workDirectory = null;
    private String engineEnvExpressionPath = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FileExpressionStore;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.workDirectory = MapUtils.getAsString((Map)serviceParams, (String)P_WORK_DIRECTORY, (String)DEFAULT_WORK_DIRECTORY);
        this.workDirectory = Utils.getCanonicalPath((String)this.getContext().getApplicationDirectory(), (String)this.workDirectory);
        this.workDirectory = this.workDirectory + File.separator;
        this.engineEnvExpressionPath = this.workDirectory + "engine-env-expression.xml";
        log.info((Object)("init() workDirectory set to " + this.workDirectory));
    }

    protected abstract void saveExpression(String var1, FlowExpression var2) throws Exception;

    protected abstract FlowExpression loadExpression(String var1) throws Exception;

    public void storeExpression(FlowExpression fe) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("storeExpression() for " + fe.getId()));
        }
        long start = System.currentTimeMillis();
        try {
            File dir = new File(this.determineDirName(fe.getId()));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = this.determineFileName(fe.getId());
            this.saveExpression(fileName, fe);
        }
        catch (Exception e) {
            throw new PoolException("Failed to store expression", e);
        }
        long duration = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("storeExpression() took " + duration + " ms"));
        }
    }

    public void unstoreExpression(FlowExpression fe) throws PoolException {
        String fileName = this.determineFileName(fe.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("unstoreExpression() deleting file " + fileName));
        }
        File f = new File(fileName);
        boolean result = f.delete();
        if (log.isDebugEnabled() && !result) {
            log.debug((Object)"unstoreExpression() delete failed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unstoreExpression() unstored   " + fe.getId()));
        }
    }

    public FlowExpression loadExpression(FlowExpressionId fei) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() requested for " + fei));
        }
        long start = System.currentTimeMillis();
        String fileName = this.determineFileName(fei);
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() fileName is " + fileName));
        }
        FlowExpression result = null;
        try {
            result = this.loadExpression(fileName);
        }
        catch (Exception e) {
            throw new PoolException("Failed to load expression", e);
        }
        long duration = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() took " + duration + " ms"));
        }
        return result;
    }

    private String getLastDigit(FlowExpressionId fei) {
        String wfid = fei.getParentWorkflowInstanceId();
        return wfid.substring(wfid.length() - 1);
    }

    protected String determineDirName(FlowExpressionId fei) {
        if (EngineEnvironmentId.ID.equals(fei)) {
            return this.workDirectory;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.workDirectory);
        sb.append(Utils.ensureForFileName((String)fei.getWorkflowDefinitionName()));
        sb.append("--");
        sb.append(Utils.ensureForFileName((String)fei.getWorkflowDefinitionRevision()));
        sb.append(File.separator);
        sb.append(this.getLastDigit(fei));
        sb.append(File.separator);
        sb.append(fei.getParentWorkflowInstanceId());
        sb.append(File.separator);
        return sb.toString();
    }

    protected String determineFileName(FlowExpressionId fei) {
        if (EngineEnvironmentId.ID.equals(fei)) {
            return this.engineEnvExpressionPath;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.determineDirName(fei));
        sb.append(Utils.ensureForFileName((String)fei.getInitialEngineId()));
        sb.append("--");
        sb.append(fei.getWorkflowInstanceId());
        sb.append("--");
        sb.append(fei.getExpressionName());
        sb.append("--");
        sb.append(fei.getExpressionId());
        sb.append(".xml");
        return sb.toString();
    }

    protected boolean cleanedDir(File dir) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleanedDir() called for  " + dir.getPath()));
        }
        if (dir.list().length > 0) {
            return false;
        }
        long lDir = -1L;
        try {
            lDir = Long.parseLong(dir.getName());
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cleanedDir() not a wfid dir >" + dir.getName() + "< skipping"));
            }
            return true;
        }
        long age = System.currentTimeMillis() - lDir;
        if (age > 60000L) {
            boolean b = dir.delete();
            if (log.isDebugEnabled()) {
                if (b) {
                    log.debug((Object)("cleanedDir() removed dir : " + dir.getPath()));
                } else {
                    log.debug((Object)("cleanedDir() failed to remove dir : " + dir.getPath()));
                }
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleanedDir() did not remove young dir : " + dir.getPath()));
        }
        return false;
    }

    public Iterator contentIterator(Class assignClass) {
        return new StoreIterator(assignClass);
    }

    private boolean isNotDigitDir(File f) {
        if (f.getName().length() != 1) {
            return true;
        }
        return !Character.isDigit(f.getName().charAt(0));
    }

    public int size() {
        int count = 0;
        File[] dirs = new File(this.workDirectory).listFiles((FileFilter)new DirectoryFilter());
        for (int i = 0; i < dirs.length; ++i) {
            File[] files = dirs[i].listFiles(new FilenameFilter(".*\\.xml"));
            count += files.length;
        }
        return count;
    }

    public Element getStatus() {
        Element eFlow;
        Element result = new Element(this.getName());
        result.addContent((Content)XmlUtils.getClassElt((Service)this));
        result.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: FileExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $"));
        int totalExpressionCount = 0;
        HashMap expressionsPerFlow = new HashMap();
        HashMap expressionsPerInstance = new HashMap();
        File workDir = new File(this.workDirectory);
        File[] flowDirs = workDir.listFiles((FileFilter)new DirectoryFilter());
        for (int i = 0; i < flowDirs.length; ++i) {
            File flowDir = flowDirs[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("getStatus() considering dir " + flowDir));
            }
            File[] digitDirs = flowDir.listFiles((FileFilter)new DirectoryFilter());
            for (int j = 0; j < digitDirs.length; ++j) {
                if (this.isNotDigitDir(digitDirs[j])) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getStatus() considering digitDir " + digitDirs[j]));
                }
                File[] wfidDirs = digitDirs[j].listFiles((FileFilter)new DirectoryFilter());
                for (int k = 0; k < wfidDirs.length; ++k) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getStatus() considering wfidDir " + wfidDirs[k]));
                    }
                    File[] expFiles = wfidDirs[k].listFiles(new ExpressionFilter());
                    totalExpressionCount += expFiles.length;
                    Utils.inc(expressionsPerFlow, (String)flowDir.getName(), (int)expFiles.length);
                    for (int l = 0; l < expFiles.length; ++l) {
                        String fileName = expFiles[l].getName();
                        String instanceId = wfidDirs[k].getName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("getStatus() considering file " + fileName));
                        }
                        Utils.inc(expressionsPerInstance, (String)instanceId);
                    }
                }
            }
        }
        Element eFlows = new Element("flows");
        Iterator it = expressionsPerFlow.keySet().iterator();
        while (it.hasNext()) {
            String flowDef = (String)it.next();
            Integer count = (Integer)expressionsPerFlow.get(flowDef);
            eFlow = new Element("flow");
            eFlow.setAttribute("def", flowDef);
            eFlow.setAttribute("expressions", count.toString());
            eFlows.addContent((Content)eFlow);
        }
        it = expressionsPerInstance.keySet().iterator();
        while (it.hasNext()) {
            String flowId = (String)it.next();
            Integer count = (Integer)expressionsPerInstance.get(flowId);
            eFlow = new Element("flow");
            eFlow.setAttribute("id", flowId);
            eFlow.setAttribute("expressions", count.toString());
            eFlows.addContent((Content)eFlow);
        }
        result.addContent((Content)eFlows);
        Element eTotalExpressionCount = new Element("expressionsStored");
        eTotalExpressionCount.addContent((Content)new Text("" + totalExpressionCount));
        result.addContent((Content)eTotalExpressionCount);
        return result;
    }

    private static long extractInstanceId(String fileName) {
        int i = fileName.indexOf("--");
        if (i < 0) {
            return -1L;
        }
        try {
            return Long.parseLong(fileName.substring(0, i));
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("failed to parse '" + fileName + "' (til '--') into a long"));
            return -1L;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class StoreIterator
    implements Iterator {
        private final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator == null ? (class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator = FileExpressionStore.class$("openwfe.org.engine.impl.expool.FileExpressionStore$StoreIterator")) : class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator).getName());
        private Class assignClass = null;
        private Level wfDirLevel = null;
        private Level digitDirLevel = null;
        private Level wfidDirLevel = null;
        private Level expressionLevel = null;
        private FlowExpression next = null;

        public StoreIterator(Class assignClass) {
            this.assignClass = assignClass;
            String[] shortNames = FileExpressionStore.this.determineExpressionShortNames(assignClass);
            this.wfDirLevel = new Level("wf    (0)", null);
            this.digitDirLevel = new Level("digit (1)", this.wfDirLevel);
            this.wfidDirLevel = new Level("wfid  (2)", this.digitDirLevel);
            this.expressionLevel = new Level("exp   (3)", this.wfidDirLevel, new FilenameFilter(shortNames));
            this.wfDirLevel.init(new File(FileExpressionStore.this.workDirectory));
            this.next = this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        private FlowExpression fetchNext() {
            File f = this.expressionLevel.next();
            if (f == null) {
                return null;
            }
            FlowExpression fe = null;
            try {
                fe = FileExpressionStore.this.loadExpression(f.getPath());
            }
            catch (Throwable t) {
                this.log.warn((Object)("next() problem iterating, skipping... " + t));
                return this.fetchNext();
            }
            if (!ExpoolUtils.isAssignableFromClass(fe, this.assignClass)) {
                this.log.warn((Object)("next() expression of class '" + fe.getClass().getName() + "' not assignable from class '" + this.assignClass.getName() + "'"));
                return this.fetchNext();
            }
            return fe;
        }

        public Object next() throws NoSuchElementException {
            FlowExpression current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.fetchNext();
            return current;
        }

        public void remove() {
        }

        protected class Level {
            public String name = null;
            public Level previous = null;
            public int index = -1;
            public File[] files = null;
            public FileFilter fFilter = null;
            public java.io.FilenameFilter fnFilter = null;

            public Level(String name, Level previous) {
                this.name = name;
                this.previous = previous;
                this.fFilter = new DirectoryFilter();
            }

            public Level(String name, Level previous, FileFilter filter) {
                this.name = name;
                this.previous = previous;
                this.fFilter = filter;
            }

            public Level(String name, Level previous, java.io.FilenameFilter filter) {
                this.name = name;
                this.previous = previous;
                this.fnFilter = filter;
            }

            public void init(File dir) {
                if (StoreIterator.this.log.isDebugEnabled()) {
                    StoreIterator.this.log.debug((Object)("init() '" + this.name + "' to " + dir.getPath()));
                }
                this.index = 0;
                this.files = this.fFilter != null ? dir.listFiles(this.fFilter) : (this.fnFilter != null ? dir.listFiles(this.fnFilter) : dir.listFiles());
                if (StoreIterator.this.log.isDebugEnabled()) {
                    if (this.files == null) {
                        StoreIterator.this.log.debug((Object)("init() '" + this.name + "' empty dir : " + dir.getPath()));
                    } else {
                        StoreIterator.this.log.debug((Object)("init() '" + this.name + "' this.files.length is " + this.files.length));
                    }
                }
            }

            public File next() {
                if (this.files == null) {
                    if (this.previous == null) {
                        return null;
                    }
                    File dir = this.previous.next();
                    if (dir == null) {
                        return null;
                    }
                    if (FileExpressionStore.this.cleanedDir(dir)) {
                        return this.next();
                    }
                    this.init(dir);
                }
                return this.pnext();
            }

            private File pnext() {
                if (this.index < this.files.length) {
                    File f = this.files[this.index];
                    ++this.index;
                    if (StoreIterator.this.log.isDebugEnabled()) {
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' f : " + f.getPath()));
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' f.exists() ? " + f.exists()));
                    }
                    if (!f.exists()) {
                        return this.pnext();
                    }
                    if (StoreIterator.this.log.isDebugEnabled()) {
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' returning " + f.getPath()));
                    }
                    return f;
                }
                this.files = null;
                return this.next();
            }
        }
    }

    private static class FilenameFilter
    implements java.io.FilenameFilter {
        private String[] shortNames = null;

        public FilenameFilter() {
        }

        public FilenameFilter(String expressionShortName) {
            this.shortNames = new String[]{expressionShortName};
        }

        public FilenameFilter(String[] expressionShortNames) {
            this.shortNames = expressionShortNames;
        }

        public boolean accept(File dir, String fileName) {
            if (!fileName.endsWith(".xml")) {
                return false;
            }
            if (this.shortNames == null) {
                return true;
            }
            for (int i = 0; i < this.shortNames.length; ++i) {
                if (!fileName.matches(".*--" + this.shortNames[i] + "--.*\\.xml")) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExpressionFilter
    implements java.io.FilenameFilter {
        private ExpressionFilter() {
        }

        public boolean accept(File dir, String fileName) {
            return fileName.endsWith(".xml");
        }
    }
}

