/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.AbstractService;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ReflectionUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.auth.ControlPermission;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.expool.FailureStrategy;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.DoExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.GoneParentId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.expressions.state.FrozenState;
import openwfe.org.engine.expressions.state.NormalState;
import openwfe.org.engine.history.History;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class SimpleExpressionPool
extends AbstractService
implements ExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$SimpleExpressionPool == null ? (class$openwfe$org$engine$impl$expool$SimpleExpressionPool = SimpleExpressionPool.class$("openwfe.org.engine.impl.expool.SimpleExpressionPool")) : class$openwfe$org$engine$impl$expool$SimpleExpressionPool).getName());
    private static final String PP_RESCHEDULE_IN = "1m";
    public static final String P_SCHEDULER_PRECISION = "schedulerPrecision";
    public static final String P_FAILURE_STRATEGY_CLASS = "failureStrategyClass";
    protected static final String DEFAULT_FAILURE_STRATEGY_CLASSNAME = (class$openwfe$org$engine$impl$expool$FailureStrategyNone == null ? (class$openwfe$org$engine$impl$expool$FailureStrategyNone = SimpleExpressionPool.class$("openwfe.org.engine.impl.expool.FailureStrategyNone")) : class$openwfe$org$engine$impl$expool$FailureStrategyNone).getName();
    private final int C_LAUNCH = -1;
    private final int C_APPLY = 1;
    private ExpressionStore store = null;
    private TimerTask purgeTask = null;
    private Scheduler scheduler = null;
    private long schedFrequency = Time.parseTimeString((String)"3m");
    private Long expressionTimeOut = null;
    private FailureStrategy failureStrategy = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$SimpleExpressionPool;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FailureStrategyNone;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ExpressionWithTimeOut;
    static /* synthetic */ Class class$openwfe$org$time$Schedulable;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String sPurgeFrequency = MapUtils.getAsString((Map)this.getParams(), (String)"purgeFrequency", (String)"4h");
        long purgeFrequency = Time.parseTimeString((String)sPurgeFrequency);
        this.purgeTask = new TimerTask(){

            public void run() {
                try {
                    SimpleExpressionPool.this.purge();
                }
                catch (Throwable t) {
                    log.warn((Object)"purgeTask : problem", t);
                }
            }
        };
        Application.getTimer().schedule(this.purgeTask, 180000L, purgeFrequency);
        log.info((Object)("init() started purge daemon every '" + sPurgeFrequency + "'"));
        float schedPrecision = MapUtils.getAsFloat((Map)serviceParams, (String)P_SCHEDULER_PRECISION, (float)0.25f);
        log.info((Object)("init() schedPrecision is " + schedPrecision));
        this.schedFrequency = MapUtils.getAsTime((Map)serviceParams, (String)"whenFrequency", (String)"2m");
        log.info((Object)("init() schedFrequency is " + this.schedFrequency + " ms"));
        this.scheduler = new Scheduler(this.getContext().getApplicationName() + "::expool.sched");
        this.scheduler.setPrecision(schedPrecision);
        this.scheduler.start();
        if (MapUtils.getAsBoolean((Map)this.getParams(), (String)"reschedule", (boolean)true)) {
            log.info((Object)"init() reschedule will occur in 1m");
            this.scheduler.scheduleIn(PP_RESCHEDULE_IN, (Schedulable)this, null);
        }
        this.expressionTimeOut = null;
        String sExpressionTimeOut = MapUtils.getAsString((Map)this.getParams(), (String)"expressionTimeout");
        if (sExpressionTimeOut != null && log.isDebugEnabled()) {
            log.debug((Object)("init() eto >" + sExpressionTimeOut + "<"));
        }
        this.expressionTimeOut = TimeoutUtils.determineTimeout(sExpressionTimeOut);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() eto 0 is " + this.expressionTimeOut));
        }
        if (this.expressionTimeOut == null) {
            this.expressionTimeOut = ExpressionPool.DEFAULT_EXPRESSION_TIMEOUT;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() eto 1 is " + this.expressionTimeOut));
        }
        if (this.expressionTimeOut > -1L) {
            log.info((Object)("init() expool (engine-level) expression timeout set to " + this.expressionTimeOut + " ms  (" + Time.toTimeString((Long)this.expressionTimeOut, (boolean)false) + ")"));
        } else {
            log.info((Object)"init() expool (engine-level) expression timeout set to 'no timeout'");
        }
        String s = MapUtils.getAsString((Map)serviceParams, (String)P_FAILURE_STRATEGY_CLASS, (String)DEFAULT_FAILURE_STRATEGY_CLASSNAME);
        try {
            this.failureStrategy = (FailureStrategy)ReflectionUtils.initObjectOfClass((String)s, (Map)serviceParams);
        }
        catch (Exception e) {
            throw new ServiceException("failed to init FailureStrategy '" + s + "'", (Throwable)e);
        }
        log.info((Object)"OpenWFE version : 1.7.1pre7");
    }

    public Long getExpressionTimeOut() {
        return this.expressionTimeOut;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void stop() throws ServiceException {
        super.stop();
        this.purgeTask.cancel();
        log.info((Object)"stop() PurgeDaemon stopped.");
        this.scheduler.stop();
        log.info((Object)"stop() scheduler stopped.");
        log.info((Object)("stop() Service '" + this.getName() + "' stopped."));
    }

    public void add(FlowExpression fe) throws PoolException {
        fe.setApplicationContext(this.getContext());
        this.getStore().storeExpression(fe);
        if (log.isDebugEnabled()) {
            log.debug((Object)("add() added  " + fe.getId()));
        }
    }

    public int size() {
        return this.getStore().size();
    }

    public synchronized Document dump() {
        Element rootElt = new Element("expool");
        Document doc = new Document(rootElt);
        List content = this.listExpressions();
        rootElt.setAttribute("time", new Date().toString());
        rootElt.setAttribute("size", "" + content.size());
        Iterator it = content.iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            rootElt.addContent((Content)fe.dump());
        }
        return doc;
    }

    public void update(FlowExpression fe) throws PoolException {
        this.getStore().storeExpression(fe);
    }

    public FlowExpression fetch(FlowExpressionId fei) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch() for " + fei));
        }
        if (fei == null) {
            return null;
        }
        FlowExpression result = null;
        try {
            result = this.getStore().loadExpression(fei);
        }
        catch (PoolException e) {
            log.info((Object)("fetch() Failed to retrieve expression " + fei + " because of " + (Object)((Object)e)));
            return null;
        }
        return result;
    }

    public Environment fetchEngineEnvironment() {
        Environment e = this.getStore().loadEngineEnvironment();
        e.setApplicationContext(this.getContext());
        return e;
    }

    public FlowExpressionId getEnvironmentId(FlowExpressionId fei) {
        FlowExpression fe = this.fetch(fei);
        if (fe == null) {
            return null;
        }
        return fe.getEnvironmentId();
    }

    public FlowExpression fetchRootOfFlow(FlowExpressionId fei) {
        FlowExpression fe = this.fetch(fei);
        FlowExpressionId parentId = fe.getParent();
        if (parentId == null) {
            return fe;
        }
        return this.fetchRootOfFlow(parentId);
    }

    protected void log(FlowExpressionId fei, WorkItem wi, String eventCode, String message) {
        History history = Definitions.getHistory(this.getContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + fei + " :: " + eventCode + " :: " + message));
        }
        if (history == null) {
            return;
        }
        history.log(fei, wi, eventCode, null, message);
    }

    private void applyOrLaunch(int command, FlowExpressionId fei, InFlowWorkItem wi) throws ApplyException {
        FlowExpression fe = this.fetch(fei);
        if (fe == null) {
            log.warn((Object)("Failed to find expression  " + fei + "  cannot apply it."));
            throw new ApplyException("Failed to find expression  " + fei + "  cannot apply it.");
        }
        this.log(fei, wi, "-dbg", "applying");
        fe.tag(wi);
        fe.touchApplyTime();
        if (command == -1) {
            fe.launch(wi);
        } else {
            SimpleExpressionPool.getState(fe).apply(wi);
        }
    }

    public void apply(FlowExpressionId fei, InFlowWorkItem wi) throws ApplyException {
        this.applyOrLaunch(1, fei, wi);
    }

    public void apply(FlowExpression fe, InFlowWorkItem wi) throws ApplyException {
        this.apply(fe.getId(), wi);
    }

    public void launch(FlowExpressionId fei, InFlowWorkItem wi) throws ApplyException {
        this.applyOrLaunch(-1, fei, wi);
    }

    public void launch(FlowExpression fe, InFlowWorkItem wi) throws ApplyException {
        this.launch(fe.getId(), wi);
    }

    public void replyToParent(FlowExpression fe, InFlowWorkItem wi) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("replyToParent() fe.id     " + fe.getId()));
            log.debug((Object)("replyToParent() fe.parent " + fe.getParent()));
        }
        if (fe.getParent() == null) {
            String message = "";
            if (fe.getId().isInSubFlow()) {
                message = "sub";
            }
            this.log(fe.getId(), wi, "+END", "");
            this.removeExpression(fe);
            return;
        }
        if (fe.getParent() == GoneParentId.GONE_PARENT_ID) {
            this.log(fe.getId(), wi, "+GNE", "");
            this.removeExpression(fe);
            return;
        }
        if (!fe.getId().getWorkflowInstanceId().equals(fe.getParent().getWorkflowInstanceId())) {
            this.log(fe.getId(), wi, "+END", "sub");
        }
        FlowExpressionId parentId = fe.getParent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("replyToParent() \n   " + fe.getId() + "\n   replies to\n   " + parentId));
        }
        if (fe.getId().getEngineId().equals(parentId.getEngineId())) {
            this.reply(parentId, wi);
        } else {
            this.replyToRemoteParent(parentId, wi);
        }
        this.removeExpression(fe);
    }

    protected void replyToRemoteParent(FlowExpressionId fei, InFlowWorkItem wi) throws ReplyException {
        this.log(fei, wi, "-dbg", "replying (to remote parent)");
        ParticipantMap pMap = Definitions.getParticipantMap(this.getContext());
        Participant parentEngine = pMap.get(fei.getEngineId());
        if (parentEngine == null) {
            throw new ReplyException("No remote engine named '" + fei.getEngineId() + "'");
        }
        try {
            parentEngine.dispatch(this.getContext(), wi);
        }
        catch (DispatchingException de) {
            throw new ReplyException("Failed to reply to remote engine '" + fei.getEngineId() + "'");
        }
    }

    public void reply(FlowExpressionId fei, InFlowWorkItem wi) throws ReplyException {
        this.log(fei, wi, "-dbg", "replying");
        FlowExpression fe = this.fetch(fei);
        if (fe == null) {
            throw new ReplyException("Cannot reply : expression not found " + fei);
        }
        SimpleExpressionPool.getState(fe).reply(wi);
        fe.tag(wi);
    }

    public void removeExpression(FlowExpression fe) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeExpression() " + fe.getId()));
        }
        try {
            if (this.getStore() != null) {
                this.getStore().unstoreExpression(fe);
            }
            if (!(fe instanceof Environment) && Environment.ownsEnvironment(fe)) {
                this.removeEnvironment(fe);
            }
            if (fe instanceof Environment) {
                ((Environment)fe).unbind();
            }
        }
        catch (PoolException pe) {
            log.warn((Object)"removeExpression() trouble", (Throwable)((Object)pe));
        }
    }

    public void removeExpression(FlowExpressionId fei) {
        FlowExpression fe;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeExpression(fei) for " + fei));
        }
        if ((fe = this.fetch(fei)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("removeExpression(fei) has already been removed : " + fei));
            }
            return;
        }
        this.removeExpression(fe);
    }

    public void removeEnvironment(FlowExpression requester) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEnvironment() for           " + requester.getId()));
            log.debug((Object)("removeEnvironment() thus removing " + requester.getEnvironmentId()));
        }
        this.removeExpression(requester.getEnvironmentId());
    }

    public InFlowWorkItem childCancel(FlowExpressionId fei) throws ApplyException {
        FlowExpression fe;
        if (log.isDebugEnabled()) {
            log.debug((Object)("childCancel() " + fei));
        }
        if ((fe = this.fetch(fei)) == null) {
            log.debug((Object)"childCancel() expression not found, not cancelling it.");
            return null;
        }
        InFlowWorkItem wi = SimpleExpressionPool.getState(fe).cancel();
        this.removeExpression(fe);
        return wi;
    }

    public void cancel(FlowExpressionId fei) {
        FlowExpression fe;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancel() " + fei));
        }
        if ((fe = this.fetch(fei)) == null) {
            return;
        }
        this.log(fei, null, "+CNX", "cancelling exp");
        try {
            InFlowWorkItem wi = SimpleExpressionPool.getState(fe).cancel();
            if (wi != null) {
                this.replyToParent(fe, wi);
            }
            this.removeExpression(fe);
        }
        catch (Throwable t) {
            log.warn((Object)"cancel() Failed to cancel an expression, removing it from pool anyway.", t);
        }
    }

    public void cancelFlow(FlowExpressionId fei) {
        FlowExpression root;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancelFlow() requested by  " + fei));
        }
        if ((root = this.fetchRootOfFlow(fei)) == null) {
            log.warn((Object)("cancelFlow() did not find root of flow for exp  " + fei + ". Cannot cancel flow"));
            return;
        }
        this.cancel(root.getId());
    }

    public void forget(FlowExpressionId fei) {
        FlowExpression fe = this.fetch(fei);
        if (fe == null) {
            return;
        }
        fe.setParent(GoneParentId.GONE_PARENT_ID);
        fe.storeItself();
    }

    public Iterator contentIterator(Class assignClass) {
        return this.getStore().contentIterator(assignClass);
    }

    protected synchronized void purge() {
        ExpressionWithTimeOut toe;
        long startTime = System.currentTimeMillis();
        HashSet<ExpressionWithTimeOut> timedOutExpressions = new HashSet<ExpressionWithTimeOut>();
        log.info((Object)"purge() starting...");
        Iterator it = this.contentIterator(class$openwfe$org$engine$expressions$ExpressionWithTimeOut == null ? (class$openwfe$org$engine$expressions$ExpressionWithTimeOut = SimpleExpressionPool.class$("openwfe.org.engine.expressions.ExpressionWithTimeOut")) : class$openwfe$org$engine$expressions$ExpressionWithTimeOut);
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            if (fe.getApplyTime() == null || !(toe = (ExpressionWithTimeOut)((Object)fe)).isTimeOutActivated() || fe.getTimeSinceApplied() <= toe.determineTimeOut()) continue;
            timedOutExpressions.add(toe);
        }
        it = timedOutExpressions.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            toe = (ExpressionWithTimeOut)o;
            FlowExpression fe = (FlowExpression)o;
            try {
                log.info((Object)("purge() Timeout reply for " + fe.getId()));
                toe.timeOutReply();
            }
            catch (ReplyException re) {
                log.warn((Object)("purge() Failed to reply to " + fe.getId()), (Throwable)((Object)re));
            }
        }
        long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
        log.info((Object)("purge() Purge ends. It took " + elapsedTime + "s."));
    }

    private DoExpression lookupDoExpression(FlowExpression caller, String doName) throws ApplyException {
        String varName = "__do__";
        varName = doName != null ? varName + doName : varName + ".*";
        FlowExpressionId doei = (FlowExpressionId)this.lookupVariable(caller, varName);
        DoExpression doe = (DoExpression)this.fetch(doei);
        if (doe == null) {
            throw new ApplyException("Cannot undo : didn't find 'do' named '" + varName + "'");
        }
        return doe;
    }

    public void undo(FlowExpression caller, String doName) throws ApplyException {
        this.lookupDoExpression(caller, doName).undo();
    }

    public void redo(FlowExpression caller, String doName) throws ApplyException {
        this.lookupDoExpression(caller, doName).redo();
    }

    private boolean isSecurityManagerPresent() {
        try {
            return System.getProperty("java.security.manager") != null;
        }
        catch (AccessControlException accessControlException) {
            return true;
        }
    }

    private void securityCheck(String actionName) {
        if (this.isSecurityManagerPresent()) {
            AccessController.checkPermission((Permission)((Object)ControlPermission.newControlPermission(this.getName(), actionName)));
        }
    }

    public List listExpressions() {
        this.securityCheck("read");
        ArrayList result = new ArrayList(2048);
        Iterator it = this.contentIterator(null);
        while (it.hasNext()) {
            result.add(it.next());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("listExpressions() returning " + result.size() + " expressions"));
        }
        return result;
    }

    public void unfreezeExpression(FlowExpressionId fei) throws PoolException {
        this.securityCheck("freeze");
        FlowExpression fe = this.fetch(fei);
        try {
            SimpleExpressionPool.getState(fe).exitState();
        }
        catch (ApplyException ae) {
            throw new PoolException("Unfreeze failure", (Throwable)((Object)ae));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unfreezeExpression() unfroze " + fei));
        }
        this.getHistory().log(fe.getId(), null, "+UFZ", null, "");
    }

    public void freezeFlow(String workflowInstanceId) throws PoolException {
        this.securityCheck("freeze");
        log.warn((Object)"freezeFlow() not yet implemented.");
        throw new PoolException("freezeFlow() not yet implemented.");
    }

    public void freezeExpression(FlowExpressionId fei) throws PoolException {
        this.securityCheck("freeze");
        FlowExpression fe = this.fetch(fei);
        if (fe.getState() != null) {
            throw new PoolException("Expression already in state '" + fe.getState().getName() + "'");
        }
        fe.setState(new FrozenState());
        fe.storeItself();
        if (log.isDebugEnabled()) {
            log.debug((Object)("freezeExpression() froze " + fei));
        }
        this.getHistory().log(fe.getId(), null, "+FRZ", null, "");
    }

    protected Environment lookupEnvironment(FlowExpression requester) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupEnvironment() requester :       " + requester.getId()));
        }
        if (requester.getEnvironmentId() == null) {
            return this.fetchEngineEnvironment();
        }
        return (Environment)this.fetch(requester.getEnvironmentId());
    }

    public Environment fetchRootEnvironment(FlowExpression requester) {
        if (requester instanceof Environment) {
            if (requester.getEnvironmentId() == null) {
                return (Environment)requester;
            }
            Environment parentEnv = (Environment)this.fetch(requester.getEnvironmentId());
            return this.fetchRootEnvironment(parentEnv);
        }
        return this.fetchRootEnvironment(this.lookupEnvironment(requester));
    }

    public void setVariable(FlowExpression requester, String variableName, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setVariable() '" + variableName + "' -> " + value));
            if (requester != null) {
                log.debug((Object)("setVariable() '" + variableName + "' for " + requester.getId()));
            }
        }
        if (variableName.startsWith("///")) {
            this.fetchEngineEnvironment().put(variableName.substring(3), value);
            return;
        }
        if (variableName.startsWith("//")) {
            this.fetchEngineEnvironment().put(variableName.substring(2), value);
            return;
        }
        if (variableName.startsWith("/")) {
            Environment rootEnv = this.fetchRootEnvironment(requester);
            rootEnv.put(variableName.substring(1), value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setVariable() put into " + rootEnv.getId()));
            }
            return;
        }
        Environment env = null;
        env = requester instanceof Environment ? (Environment)requester : this.lookupEnvironment(requester);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setVariable() in local env  " + env.getId()));
        }
        env.put(variableName, value);
    }

    public Object lookupVariable(FlowExpression requester, String variableName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupVariable() requester is  " + requester.getId()));
            log.debug((Object)("lookupVariable() varname is   >" + variableName + "<"));
        }
        if (variableName.startsWith("///")) {
            return this.fetchEngineEnvironment().get(variableName.substring(3));
        }
        if (variableName.startsWith("//")) {
            return this.fetchEngineEnvironment().get(variableName.substring(2));
        }
        if (variableName.startsWith("/")) {
            return this.fetchRootEnvironment(requester).get(variableName.substring(1));
        }
        Environment e = this.lookupEnvironment(requester);
        if (e == null) {
            log.error((Object)("lookupVariable() didn't find environment for  " + requester.getId()));
            return null;
        }
        return e.lookup(variableName);
    }

    public Environment lookupContainingEnvironment(FlowExpression requester, String variableName) {
        if (variableName.startsWith("//")) {
            return this.fetchEngineEnvironment();
        }
        if (variableName.startsWith("/")) {
            return this.fetchRootEnvironment(requester);
        }
        Environment env = this.lookupEnvironment(requester);
        return env.lookupContainingEnvironment(variableName);
    }

    public Object lookupLocalVariable(FlowExpression requester, String variableName) {
        Environment localEnv = this.lookupEnvironment(requester);
        return localEnv.get(variableName);
    }

    protected void reschedule() {
        log.info((Object)"reschedule() ...");
        log.debug((Object)"reschedule() from pool...");
        Iterator it = this.contentIterator(class$openwfe$org$time$Schedulable == null ? (class$openwfe$org$time$Schedulable = SimpleExpressionPool.class$("openwfe.org.time.Schedulable")) : class$openwfe$org$time$Schedulable);
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            this.reschedule(fe);
        }
        log.debug((Object)"reschedule() from engine-env...");
        it = this.fetchEngineEnvironment().getVariables().values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Schedulable)) continue;
            FlowExpression fe = (FlowExpression)o;
            this.reschedule(fe);
        }
        log.info((Object)"reschedule() done.");
    }

    protected void reschedule(FlowExpression fe) {
        fe.setApplicationContext(this.getContext());
        ((Schedulable)fe).reschedule(this.getScheduler());
        log.info((Object)("reschedule() rescheduled  " + fe.getId()));
    }

    public Long reschedule(Scheduler s) {
        return new Long(-1L);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void trigger(Object[] params) {
        if (params == null) {
            log.debug((Object)"trigger() rescheduling...");
            this.reschedule();
            return;
        }
        log.debug((Object)"trigger() scheduling");
        Object o = params[0];
        Schedulable schedulableExpression = null;
        if (o instanceof Schedulable) {
            schedulableExpression = (Schedulable)o;
        } else if (o instanceof FlowExpressionId) {
            schedulableExpression = (Schedulable)this.fetch((FlowExpressionId)o);
        } else {
            log.warn((Object)("trigger() cannot reschedule instance of " + o.getClass().getName()));
            return;
        }
        if (schedulableExpression == null) {
            log.warn((Object)"trigger() did not find schedulable expression. Forgetting it");
            return;
        }
        schedulableExpression.trigger(null);
    }

    public void schedule(FlowExpressionId fei) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("schedule()  " + fei));
        }
        this.scheduler.scheduleIn(this.getSchedFrequency(), (Schedulable)this, new Object[]{fei.copy()});
    }

    public void scheduleAt(long at, FlowExpressionId fei) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("scheduleAt() at " + new Date(at) + "  " + fei));
        }
        this.scheduler.scheduleAt(at, (Schedulable)this, new Object[]{fei.copy()});
    }

    public long getSchedFrequency() {
        return this.schedFrequency;
    }

    public String dumpExpool() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.listExpressions().iterator();
        while (it.hasNext()) {
            FlowExpression e = (FlowExpression)it.next();
            sb.append("- ").append(e.getId().toString()).append("\n");
            String sParent = "";
            if (e.getParent() != null) {
                sParent = e.getParent().toString();
            }
            sb.append("     p-> ").append(sParent).append("\n");
        }
        return sb.toString();
    }

    public static ExpressionState getState(FlowExpression fe) {
        ExpressionState state = fe.getState();
        if (state == null) {
            state = new NormalState();
        }
        state.setExpression(fe);
        return state;
    }

    protected History getHistory() {
        return Definitions.getHistory(this.getContext());
    }

    public Element getStatus() {
        Element result = new Element(this.getName());
        result.addContent((Content)XmlUtils.getClassElt((Service)this));
        result.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: SimpleExpressionPool.java 2852 2006-06-22 07:04:12Z jmettraux $"));
        Element pecElt = new Element("pooledExpressionCount");
        pecElt.addContent("" + this.getStore().size());
        result.addContent((Content)pecElt);
        return result;
    }

    protected ExpressionStore getStore() {
        if (this.store != null) {
            return this.store;
        }
        this.store = Definitions.getExpressionStore(this.getContext());
        return this.store;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

