/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.history;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.history.HistoryIterator;
import openwfe.org.engine.impl.history.AbstractHistory;
import openwfe.org.engine.workitem.WorkItem;
import org.apache.log4j.Logger;

public class TextHistory
extends AbstractHistory {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$history$TextHistory == null ? (class$openwfe$org$engine$impl$history$TextHistory = TextHistory.class$("openwfe.org.engine.impl.history.TextHistory")) : class$openwfe$org$engine$impl$history$TextHistory).getName());
    public static final String P_FILE_NAME = "fileName";
    private PrintWriter out = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$history$TextHistory;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String fileName = MapUtils.getAsString((Map)this.getParams(), (String)P_FILE_NAME, (String)"logs/history.log");
        try {
            this.out = new PrintWriter(new FileWriter(fileName));
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to init history with file " + fileName), t);
        }
    }

    public void stop() throws ServiceException {
        super.stop();
        this.out.close();
        log.info((Object)("'" + this.getName() + "' stopped."));
    }

    protected void doLog(FlowExpressionId fei, WorkItem wi, String eventCode, String participantName, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(new Date());
        sb.append(" ");
        sb.append(eventCode);
        sb.append(" ");
        if (fei != null) {
            sb.append(fei.getEngineId());
            sb.append("::");
            sb.append(fei.getWorkflowDefinitionUrl());
            sb.append(" ");
            sb.append(fei.getWorkflowInstanceId());
            sb.append("   ");
            sb.append(fei.getExpressionId());
            sb.append(" ");
            sb.append(fei.getExpressionName());
            sb.append(" ");
        }
        if (participantName != null) {
            sb.append("'");
            sb.append(participantName);
            sb.append("'");
        }
        sb.append(" ");
        sb.append(message);
        this.out.println(sb);
        this.out.flush();
    }

    public HistoryIterator browse(String workflowName, String workflowRevision, long workflowInstanceId, long dateFrom, long dateto) throws HistoryException {
        throw new HistoryException("Not yet implemented.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

