/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.util.HashMap;
import openwfe.org.ApplicationContext;
import openwfe.org.OpenWfeException;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.impl.dispatch.SocketDispatcher;
import openwfe.org.engine.impl.listen.SocketListener;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.XmlCoderLoader;

public abstract class OwfeHook {
    private int listenPort = -1;
    private String engineHost = null;
    private int enginePort = -1;
    private ApplicationContext applicationContext = null;

    public OwfeHook(int listenPort, String engineHost, int enginePort) throws ServiceException {
        this.listenPort = listenPort;
        this.engineHost = engineHost;
        this.enginePort = enginePort;
        this.applicationContext = new ApplicationContext();
        SocketListener sl = new SocketListener();
        HashMap<String, String> slParams = new HashMap<String, String>();
        slParams.put("port", "7303");
        slParams.put("workItemConsumer", "consumer");
        sl.init("listener", this.applicationContext, slParams);
        this.applicationContext.add((Service)sl);
        XmlCoderLoader coderLoader = new XmlCoderLoader();
        HashMap<String, String> clParams = new HashMap<String, String>(1);
        clParams.put("configurationFile", "resource:/coder-configuration.xml");
        coderLoader.init("workItemCoderLoader", this.applicationContext, clParams);
        this.applicationContext.add((Service)coderLoader);
        final SocketDispatcher dispatcher = new SocketDispatcher();
        HashMap<String, String> dParams = new HashMap<String, String>();
        dParams.put("host", "engine.host.com");
        dParams.put("port", "7007");
        dParams.put("workItemCoder", "xmlCoder");
        dispatcher.init("dispatcher", this.applicationContext, dParams);
        WorkItemConsumer consumer = new WorkItemConsumer(){

            public Object use(WorkItem wi) throws OpenWfeException {
                OwfeHook.this.service(wi);
                dispatcher.dispatch(wi);
                return null;
            }
        };
        this.applicationContext.put("consumer", (Object)consumer);
    }

    public abstract void service(WorkItem var1);

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

