/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ExceptionUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.net.ChannelInputStream;
import openwfe.org.net.SocketService;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class SocketListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$SocketListener == null ? (class$openwfe$org$engine$impl$listen$SocketListener = SocketListener.class$("openwfe.org.engine.impl.listen.SocketListener")) : class$openwfe$org$engine$impl$listen$SocketListener).getName());
    public static final String EMBEDDED_SOCKET_SERVICE = ".embedded_socket_service";
    private SocketService socketService = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$SocketListener;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.socketService = new SocketService(){

            public void handle(SelectionKey key) throws ServiceException {
                SocketListener.this.handle(key);
            }

            public Element getStatus() {
                return new Element(this.getName());
            }
        };
        this.socketService.setDefaultPort(7007);
        this.socketService.init(serviceName + EMBEDDED_SOCKET_SERVICE, context, serviceParams);
    }

    public void stop() throws ServiceException {
        try {
            this.socketService.stop();
        }
        catch (ServiceException se) {
            throw new ServiceException("Embedded SocketService failed to stop correctly", (Throwable)se);
        }
        log.info((Object)("Service '" + this.getName() + "' got stopped."));
    }

    public Element getStatus() {
        Element status = new Element(this.getName());
        status.addContent((Content)this.socketService.getStatus());
        return status;
    }

    private void reply(WorkItemCoder coder, SocketChannel channel, ListenerReply r) throws IOException, CodingException {
        byte[] encodedReply = coder.getReplyCoder().encode(r);
        channel.write(ByteBuffer.wrap(encodedReply));
    }

    private void handle(SelectionKey key) {
        long start = System.currentTimeMillis();
        SocketChannel channel = (SocketChannel)key.channel();
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle() Incoming connection from " + channel.socket().getInetAddress()));
        }
        WorkItem wi = null;
        WorkItemCoder coder = null;
        ListenerReply reply = null;
        try {
            ChannelInputStream is = new ChannelInputStream((ReadableByteChannel)channel);
            Object[] cl = this.determineCoderAndLength(is);
            coder = (WorkItemCoder)cl[0];
            Integer iLength = (Integer)cl[1];
            if (iLength > -1) {
                is.setBytesToRead(iLength.intValue());
            }
            wi = coder.decode(is, this.getContext(), this.getParams());
            if (log.isDebugEnabled()) {
                log.debug((Object)("handle() received wi of class " + wi.getClass().getName()));
            }
            Object result = this.getConsumer().use(wi);
            reply = new OkReply(result);
        }
        catch (Throwable t) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            reply = new FatalReply("Fatal reply : " + rootCause.toString() + " : " + rootCause.getMessage(), t);
            log.warn((Object)("handle() Fatal reply : " + t), t);
        }
        try {
            if (coder != null) {
                this.reply(coder, channel, reply);
            } else {
                log.warn((Object)"handle() cannot reply : no coder found !");
            }
        }
        catch (Throwable t) {
            log.warn((Object)"handle() failed to reply to dispatcher", t);
        }
        try {
            channel.close();
        }
        catch (Throwable t) {
            log.warn((Object)"handle() Channel to dispatcher closed with an exception ?!?", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle() took " + (System.currentTimeMillis() - start)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

