/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.CompositeParticipant;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.participants.Participant;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlParticipantMap
extends AbstractParticipantMap
implements XconfElementBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$XmlParticipantMap == null ? (class$openwfe$org$engine$impl$participants$XmlParticipantMap = XmlParticipantMap.class$("openwfe.org.engine.impl.participants.XmlParticipantMap")) : class$openwfe$org$engine$impl$participants$XmlParticipantMap).getName());
    private static final String E_PARTICIPANT = "participant";
    private static final String A_NAME = "name";
    private static final String A_REGEX = "regex";
    private static final String A_REF = "ref";
    private static final String A_CLASS = "class";
    public static final String P_PARTICIPANT_MAP_FILE = "participantMapFile";
    private XconfBuilder builder = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$XmlParticipantMap;
    static /* synthetic */ Class class$openwfe$org$engine$participants$RefParticipant;
    static /* synthetic */ Class class$openwfe$org$engine$participants$LeafParticipant;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String url = MapUtils.getAsString((Map)serviceParams, (String)P_PARTICIPANT_MAP_FILE, (String)"etc/engine/participant-map.xml");
        url = Utils.expandUrl((String)context.getApplicationDirectory(), (String)url);
        log.info((Object)("init() url is " + url));
        this.builder = new XconfBuilder(url, (XconfElementBuilder)this);
        this.builder.buildConfig();
    }

    public void clearConfig() {
        this.setParticipants(new ArrayList());
    }

    public void parseElement(XconfBuilder builder, Element elt) throws ServiceException {
        this.buildParticipant(elt);
    }

    public void refreshMap() throws ServiceException {
        this.builder.refreshConfig();
    }

    protected Participant buildParticipant(Element elt) {
        String specifiedClassName;
        if (!elt.getName().equals(E_PARTICIPANT)) {
            return null;
        }
        String regex = elt.getAttributeValue(A_REGEX);
        if (regex == null) {
            regex = elt.getAttributeValue(A_NAME);
        }
        Map params = Parameters.extractParamsAndAttributes((Element)elt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildParticipant() building '" + regex + "'"));
        }
        if (elt.getChild(E_PARTICIPANT) != null) {
            return this.buildCompositeParticipant(elt, regex, params);
        }
        String className = null;
        String ref = elt.getAttributeValue(A_REF);
        if (ref != null) {
            className = (class$openwfe$org$engine$participants$RefParticipant == null ? (class$openwfe$org$engine$participants$RefParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.RefParticipant")) : class$openwfe$org$engine$participants$RefParticipant).getName();
        }
        if ((specifiedClassName = (String)params.get(A_CLASS)) != null) {
            className = specifiedClassName;
        }
        Participant p = null;
        try {
            Class participantClass;
            Class clazz = participantClass = class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant;
            if (className != null) {
                participantClass = Class.forName(className);
            }
            p = (Participant)participantClass.newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)("buildParticipant() cannot build from class " + className + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("buildParticipant() cannot build from class " + className + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()), t);
            }
            p = new LeafParticipant();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildParticipant() of class '" + p.getClass().getName() + "'"));
        }
        p.init(regex, params);
        this.add(p);
        return p;
    }

    protected CompositeParticipant buildCompositeParticipant(Element elt, String regex, Map params) {
        CompositeParticipant cp = new CompositeParticipant();
        cp.init(regex, params);
        this.add(cp);
        Iterator it = elt.getChildren(E_PARTICIPANT).iterator();
        while (it.hasNext()) {
            cp.add(this.buildParticipant((Element)it.next()));
        }
        return cp;
    }

    public Element getStatus() {
        Element result = new Element(this.getName());
        result.setAttribute("source-url", this.builder.getSourceUrl().toString());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

