/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.FactoryException;
import openwfe.org.MapUtils;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.impl.participants.AbstractParticipantMapFactory;
import openwfe.org.engine.participants.CompositeParticipant;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlParticipantMapFactory
extends AbstractParticipantMapFactory
implements XconfElementBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$XmlParticipantMapFactory == null ? (class$openwfe$org$engine$impl$participants$XmlParticipantMapFactory = XmlParticipantMapFactory.class$("openwfe.org.engine.impl.participants.XmlParticipantMapFactory")) : class$openwfe$org$engine$impl$participants$XmlParticipantMapFactory).getName());
    private static final String E_PARTICIPANT = "participant";
    private static final String A_NAME = "name";
    private static final String A_REGEX = "regex";
    private static final String A_REF = "ref";
    private static final String A_CLASS = "class";
    public static final String P_PARTICIPANT_MAP_FILE = "participantMapFile";
    private XconfBuilder builder = null;
    private List participants = new ArrayList(35);
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$XmlParticipantMapFactory;
    static /* synthetic */ Class class$openwfe$org$engine$participants$RefParticipant;
    static /* synthetic */ Class class$openwfe$org$engine$participants$LeafParticipant;

    public XmlParticipantMapFactory() {
    }

    public XmlParticipantMapFactory(String pmapUrl) throws ServiceException {
        this();
        this.builder = new XconfBuilder(pmapUrl, (XconfElementBuilder)this);
    }

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String url = MapUtils.getAsString((Map)serviceParams, (String)P_PARTICIPANT_MAP_FILE, (String)"etc/engine/participant-map.xml");
        url = Utils.expandUrl((String)context.getApplicationDirectory(), (String)url);
        log.debug((Object)("init() url is " + url));
        this.builder = new XconfBuilder(url, (XconfElementBuilder)this);
    }

    public void clearConfig() {
        this.participants.clear();
    }

    public void parseElement(XconfBuilder builder, Element elt) throws ServiceException {
        this.buildParticipant(elt);
    }

    public List createParticipants(ParticipantMap m) throws FactoryException {
        try {
            this.builder.buildConfig();
        }
        catch (Throwable t) {
            throw new FactoryException("failed to create participants", t);
        }
        return this.participants;
    }

    public boolean hasSourceChanged() throws FactoryException {
        return this.builder.hasSourceBeenModified();
    }

    protected Participant buildParticipant(Element elt) {
        String specifiedClassName;
        if (!elt.getName().equals(E_PARTICIPANT)) {
            return null;
        }
        String regex = elt.getAttributeValue(A_REGEX);
        if (regex == null) {
            regex = elt.getAttributeValue(A_NAME);
        }
        Map params = Parameters.extractParamsAndAttributes((Element)elt);
        log.debug((Object)("buildParticipant() building '" + regex + "'"));
        if (elt.getChild(E_PARTICIPANT) != null) {
            return this.buildCompositeParticipant(elt, regex, params);
        }
        String className = null;
        String ref = elt.getAttributeValue(A_REF);
        if (ref != null) {
            className = (class$openwfe$org$engine$participants$RefParticipant == null ? (class$openwfe$org$engine$participants$RefParticipant = XmlParticipantMapFactory.class$("openwfe.org.engine.participants.RefParticipant")) : class$openwfe$org$engine$participants$RefParticipant).getName();
        }
        if ((specifiedClassName = (String)params.get(A_CLASS)) != null) {
            className = specifiedClassName;
        }
        Participant p = null;
        try {
            Class participantClass;
            Class clazz = participantClass = class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMapFactory.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant;
            if (className != null) {
                participantClass = Class.forName(className);
            }
            p = (Participant)participantClass.newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)("buildParticipant() cannot build from class " + className + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMapFactory.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()));
            log.debug((Object)("buildParticipant() cannot build from class " + className + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMapFactory.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()), t);
            p = new LeafParticipant();
        }
        log.debug((Object)("buildParticipant() of class '" + p.getClass().getName() + "'"));
        p.init(regex, params);
        this.participants.add(p);
        return p;
    }

    protected CompositeParticipant buildCompositeParticipant(Element elt, String regex, Map params) {
        CompositeParticipant cp = new CompositeParticipant();
        cp.init(regex, params);
        Iterator it = elt.getChildren(E_PARTICIPANT).iterator();
        while (it.hasNext()) {
            cp.add(this.buildParticipant((Element)it.next()));
        }
        this.participants.add(cp);
        return cp;
    }

    public Element getStatus() {
        String name = this.getName();
        if (name == null) {
            name = this.getClass().getName();
        }
        Element result = new Element(name);
        result.setAttribute("source-url", this.builder.getSourceUrl().toString());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

