/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.misc.Text;

public class MailFormCoder
implements WorkItemCoder {
    private static final String ID_PREFIX = " -- id : ";
    private static final String FIELD_END = " -- X --";
    private String name = null;
    private ListenerReplyCoder replyCoder = null;

    public void init(String name, List attributeCoders, ListenerReplyCoder replyCoder) {
        this.name = name;
        this.replyCoder = replyCoder;
    }

    public String getName() {
        return this.name;
    }

    public ListenerReplyCoder getReplyCoder() {
        return this.replyCoder;
    }

    public WorkItem decode(Object o, ApplicationContext context, Map serviceParams) throws CodingException {
        Reader r = null;
        if (o instanceof Reader) {
            r = (Reader)o;
        } else if (o instanceof String) {
            r = new StringReader((String)o);
        } else {
            throw new CodingException("Cannot decode workitem out of object of class " + o.getClass().getName());
        }
        InFlowWorkItem result = null;
        BufferedReader br = new BufferedReader(r);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = this.removeBracket(line);
                if (result == null) {
                    int ip = line.indexOf(ID_PREFIX);
                    if (ip < 0) continue;
                    line = line.substring(ip);
                    String sId = line.substring(ID_PREFIX.length());
                    FlowExpressionId fei = FlowExpressionId.fromParseableString(sId);
                    result = this.fetchWorkitem(context, fei);
                    continue;
                }
                if (line.indexOf(FIELD_END) >= 0) {
                    break;
                }
                int i = line.indexOf(":");
                if (i < 2) continue;
                String field = line.substring(0, i).trim();
                i = line.indexOf("[");
                String value = line.substring(i + 1);
                if ((i = value.lastIndexOf("]")) > 0) {
                    value = value.substring(0, i);
                }
                result.getAttributes().puts(field, value);
            }
        }
        catch (IOException e) {
            throw new CodingException("Failed to decode mail form workitem", e);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable t) {}
        }
        return result;
    }

    private String removeBracket(String in) {
        if (in.startsWith(">")) {
            return in.substring(1);
        }
        return in;
    }

    public Object encode(WorkItem wi, ApplicationContext context, Map serviceParams) throws CodingException {
        boolean monospace = true;
        if (serviceParams != null) {
            MapUtils.getAsBoolean((Map)serviceParams, (String)"monospace", (boolean)true);
        }
        InFlowWorkItem ifwi = (InFlowWorkItem)wi;
        StringBuffer result = new StringBuffer();
        String sHeader = wi.getAttributes().sget("mf_header");
        if (sHeader != null) {
            result.append(sHeader).append("\n");
        }
        this.printSep(result, ifwi);
        String sFields = wi.getAttributes().sget("mf_fields");
        if (sFields != null) {
            String[] fields = sFields.split(", *");
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].trim();
                String field = fieldName + " : ";
                String value = wi.getAttributes().sget(fieldName);
                if (value == null) {
                    value = "";
                }
                if (monospace) {
                    field = Text.adjust((String)field, (int)25, (boolean)false);
                }
                result.append(field).append("[ ").append(value).append(" ]").append("\n");
            }
        }
        result.append("\n").append(FIELD_END).append("\n\n");
        String sFooter = wi.getAttributes().sget("mf_footer");
        if (sFooter != null) {
            result.append(sFooter).append("\n");
        }
        try {
            return result.toString().getBytes(Utils.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new CodingException("Failed to encode workitem", e);
        }
    }

    public AttributeCoder getAttributeCoder(Attribute a) {
        return null;
    }

    public AttributeCoder getAttributeCoder(Class attributeClass) {
        return null;
    }

    public AttributeCoder getAttributeCoder(String representation) {
        return null;
    }

    private void printSep(StringBuffer sb, InFlowWorkItem wi) {
        sb.append("\n").append(ID_PREFIX).append(wi.getLastExpressionId().toParseableString()).append("\n\n");
    }

    protected InFlowWorkItem fetchWorkitem(ApplicationContext context, FlowExpressionId workitemId) {
        ParticipantExpression pe = (ParticipantExpression)Definitions.getExpressionPool(context).fetch(workitemId);
        return (InFlowWorkItem)pe.getAppliedWorkitem().clone();
    }

    public static void main(String[] args) throws Exception {
        InFlowWorkItem wi = new InFlowWorkItem();
        wi.setId(new FlowExpressionId());
        wi.getAttributes().puts("mf_fields", "color, size, quantity");
        wi.getAttributes().puts("mf_header", "This is our offer");
        wi.getAttributes().puts("mf_footer", "Best regards,\n\nJohn");
        wi.getAttributes().puts("color", "blue");
        wi.getAttributes().puts("size", "XL");
        MailFormCoder coder = new MailFormCoder();
        String s = new String((byte[])coder.encode(wi, null, null), Utils.getEncoding());
        System.out.println(s);
        wi = (InFlowWorkItem)coder.decode(new StringReader(s), null, null);
        System.out.println();
        System.out.println("color    : " + wi.getAttributes().sget("color"));
        System.out.println("size     : " + wi.getAttributes().sget("size"));
        System.out.println("quantity : " + wi.getAttributes().sget("quantity"));
    }
}

