/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import openwfe.org.engine.workitem.CodingException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class WicUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$workitem$xml$WicUtils == null ? (class$openwfe$org$engine$impl$workitem$xml$WicUtils = WicUtils.class$("openwfe.org.engine.impl.workitem.xml.WicUtils")) : class$openwfe$org$engine$impl$workitem$xml$WicUtils).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$workitem$xml$WicUtils;

    public static Element enforceElement(Object o, String nodeName) throws CodingException {
        if (o == null) {
            throw new CodingException("Null element. Should be '" + nodeName + "'");
        }
        if (!(o instanceof Element)) {
            throw new CodingException("Object to decode should be of class 'org.jdom.Element'. Received a '" + o.getClass().getName() + "' instead.");
        }
        Element elt = (Element)o;
        if (!elt.getName().equals(nodeName)) {
            throw new CodingException("Excpected a <" + nodeName + "> element not a <" + elt.getName() + "> one.");
        }
        return elt;
    }

    public static void setAttribute(Element elt, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return;
        }
        elt.setAttribute(attributeName, attributeValue);
    }

    public static Element fetchElementFromStream(InputStream is) throws CodingException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(is);
            is.close();
        }
        catch (Exception e) {
            throw new CodingException("Failed to decode xml element", e);
        }
        return doc.getRootElement();
    }

    public static long getLong(Element elt, String attributeName) throws CodingException {
        return WicUtils.getLong(elt, attributeName, null);
    }

    public static long getLong(Element elt, String attributeName, long defaultValue) throws CodingException {
        return WicUtils.getLong(elt, attributeName, new Long(defaultValue));
    }

    private static long getLong(Element elt, String attributeName, Long defaultValue) throws CodingException {
        if (elt == null || attributeName == null) {
            throw new CodingException("Cannot extract a long from a null element or a from a 'null' attribute");
        }
        String sLong = elt.getAttributeValue(attributeName);
        try {
            return Long.parseLong(sLong);
        }
        catch (NumberFormatException nfe) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new CodingException("Cannot extract a long from '" + sLong + "'");
        }
    }

    public static String toString(Element elt) {
        if (elt == null) {
            return "<nil/>";
        }
        try {
            XMLOutputter out = new XMLOutputter();
            StringWriter writer = new StringWriter();
            out.output(elt, (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (IOException ie) {
            return "Failed to output as string xml for element named '" + elt.getName() + "' : " + ie;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

