/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.listen;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.OpenWfeException;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.history.History;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.listen.AbstractWorkItemConsumer;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class EngineWorkItemConsumer
extends AbstractWorkItemConsumer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$listen$EngineWorkItemConsumer == null ? (class$openwfe$org$engine$listen$EngineWorkItemConsumer = EngineWorkItemConsumer.class$("openwfe.org.engine.listen.EngineWorkItemConsumer")) : class$openwfe$org$engine$listen$EngineWorkItemConsumer).getName());
    public static final String P_PROCESS_DEFINITION_IN_FIELD = "processDefinitionInField";
    public static final String P_ARCHIVE_PROCESS_DEFINITION_IN_FIELD = "archiveProcessDefinitionInField";
    private String processDefinitionField = null;
    private String archiveProcessDefinitionField = null;
    static /* synthetic */ Class class$openwfe$org$engine$listen$EngineWorkItemConsumer;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.processDefinitionField = MapUtils.getAsString((Map)serviceParams, (String)P_PROCESS_DEFINITION_IN_FIELD);
        if (this.processDefinitionField != null) {
            log.info((Object)("init() processDefinitionField set to '" + this.processDefinitionField + "'"));
        }
        this.archiveProcessDefinitionField = MapUtils.getAsString((Map)serviceParams, (String)P_ARCHIVE_PROCESS_DEFINITION_IN_FIELD);
        if (this.archiveProcessDefinitionField != null) {
            log.info((Object)("init() archiveProcessDefinitionField set to '" + this.archiveProcessDefinitionField + "'"));
        }
    }

    public Object use(final WorkItem wi) throws OpenWfeException {
        Attribute a;
        if (wi instanceof LaunchItem) {
            return this.getLauncher().launch((LaunchItem)wi, true);
        }
        if (!(wi instanceof InFlowWorkItem)) {
            throw new OpenWfeException("The engine cannot use a WorkItem of class " + wi.getClass().getName());
        }
        InFlowWorkItem ifwi = (InFlowWorkItem)wi;
        if (log.isDebugEnabled()) {
            log.debug((Object)("use() received workitem with id  " + ifwi.getLastExpressionId()));
            log.debug((Object)("use() received workitem for participant '" + ifwi.getParticipantName() + "'"));
        }
        if (this.processDefinitionField != null && (a = ifwi.getAttributes().getField(this.processDefinitionField)) != null && (a instanceof StringAttribute || a instanceof XmlAttribute)) {
            this.archiveProcessDefinition(a, ifwi);
            this.getLauncher().launch(ifwi, ifwi.getId(), "field:" + this.processDefinitionField, true);
            return null;
        }
        new Thread(){

            public void run() {
                try {
                    EngineWorkItemConsumer.this.reply((InFlowWorkItem)wi);
                }
                catch (Throwable t) {
                    log.error((Object)"use() problem while replying", t);
                }
            }
        }.start();
        return null;
    }

    protected void archiveProcessDefinition(Attribute definition, InFlowWorkItem wi) {
        if (this.archiveProcessDefinitionField == null) {
            return;
        }
        Attribute a = wi.getAttributes().getField(this.archiveProcessDefinitionField);
        if (a != null && !(a instanceof ListAttribute)) {
            log.error((Object)("archiveProcessDefinition() field '" + this.archiveProcessDefinitionField + "' is of class " + a.getClass().getName()));
            return;
        }
        ListAttribute archive = (ListAttribute)a;
        if (archive == null) {
            archive = new ListAttribute();
            wi.getAttributes().setField(this.archiveProcessDefinitionField, archive);
        }
        archive.add(definition);
    }

    protected void reply(InFlowWorkItem wi) throws ReplyException {
        History h = Definitions.getHistory(this.getContext());
        if (h != null) {
            h.log(wi.getLastExpressionId(), wi, "+INC", wi.getParticipantName(), "");
        }
        Definitions.getExpressionPool(this.getContext()).reply(wi.getLastExpressionId(), wi);
    }

    public String getProcessDefinitionField() {
        return this.processDefinitionField;
    }

    public String getArchiveProcessDefinitionField() {
        return this.archiveProcessDefinitionField;
    }

    protected Launcher getLauncher() {
        return Definitions.getLauncher(this.getContext());
    }

    public Element getStatus() {
        Element result = new Element(this.getName());
        result.addContent((Content)XmlUtils.getClassElt((Service)this));
        result.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: EngineWorkItemConsumer.java 2809 2006-06-13 07:47:34Z jmettraux $"));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

