/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.participants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import org.apache.log4j.Logger;

public class Filter
implements Serializable {
    static final long serialVersionUID = -1652507046784415271L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$participants$Filter == null ? (class$openwfe$org$engine$participants$Filter = Filter.class$("openwfe.org.engine.participants.Filter")) : class$openwfe$org$engine$participants$Filter).getName());
    private static final Filter noFilter = new NoFilter();
    public static final int TYPE_OPEN = 0;
    public static final int TYPE_CLOSED = 1;
    private String name = null;
    private int type = -1;
    private boolean addAllowed = true;
    private boolean removeAllowed = false;
    private List entries = null;
    static /* synthetic */ Class class$openwfe$org$engine$participants$Filter;

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAddAllowed() {
        return this.addAllowed;
    }

    public boolean isRemoveAllowed() {
        return this.removeAllowed;
    }

    public List getEntries() {
        return this.entries;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setAddAllowed(boolean b) {
        this.addAllowed = b;
    }

    public void setRemoveAllowed(boolean b) {
        this.removeAllowed = b;
    }

    public void setEntries(List l) {
        this.entries = l;
    }

    private boolean hasPermission(String fieldName, char permissionChar) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasPermission() fieldName >" + fieldName + "<"));
        }
        return this.getPermissions(fieldName).indexOf(permissionChar) > -1;
    }

    private String getPermissions(String fieldName) {
        String s = this.getPermissionString(fieldName);
        if (s != null) {
            return s;
        }
        if (this.type == 0) {
            return "rw";
        }
        return "";
    }

    private String getPermissionString(String fieldName) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            FilterEntry entry = (FilterEntry)it.next();
            if (entry.getFieldRegex() == null || !fieldName.matches(entry.getFieldRegex())) continue;
            return entry.getPermissions().toLowerCase().trim();
        }
        return null;
    }

    private boolean knowsAbout(String fieldName) {
        return this.getPermissions(fieldName) != null;
    }

    public boolean allowWrite(String fieldName) {
        return this.hasPermission(fieldName, 'w');
    }

    public boolean allowRead(String fieldName) {
        return this.hasPermission(fieldName, 'r');
    }

    public boolean allowRemove(String fieldName) {
        if (!this.removeAllowed) {
            return false;
        }
        return this.allowWrite(fieldName);
    }

    public InFlowWorkItem constrain(InFlowWorkItem workItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("constrain() filter '" + this.name + "'"));
        }
        InFlowWorkItem result = new InFlowWorkItem();
        result.setId(workItem.getId());
        result.setParticipantName(workItem.getParticipantName());
        result.setLastModified(workItem.getLastModified());
        result.setAttributes(new StringMapAttribute(workItem.getAttributes().size()));
        result.setHistory(workItem.getHistory());
        Iterator it = workItem.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String attributeName = ((StringAttribute)it.next()).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("constrain() considering attribute named >" + attributeName + "<"));
            }
            if (this.type == 0) {
                if (this.hasPermission(attributeName, 'r') || !"".equals(this.getPermissions(attributeName))) {
                    result.getAttributes().put(attributeName, (Attribute)workItem.getAttribute(attributeName).clone());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("constrain() (open) added attribute >" + attributeName + "<"));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("constrain() (open) discarding attribute >" + attributeName + "<"));
                continue;
            }
            if (this.hasPermission(attributeName, 'r')) {
                result.getAttributes().put(attributeName, (Attribute)workItem.getAttribute(attributeName).clone());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("constrain() (closed) added attribute >" + attributeName + "<"));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("constrain() (closed) discarding attribute >" + attributeName + "<"));
        }
        result.setFilter(this);
        return result;
    }

    public InFlowWorkItem enforce(InFlowWorkItem initialWorkItem, InFlowWorkItem modifiedWorkItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enforce() filter '" + this.name + "' isAddAllowed ? " + this.addAllowed));
            log.debug((Object)("enforce() filter '" + this.name + "' isRemoveAllowed ? " + this.removeAllowed));
        }
        Iterator it = modifiedWorkItem.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            boolean isNewAttribute;
            String attributeName = ((StringAttribute)it.next()).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("enforce() filter '" + this.name + "' considering att '" + attributeName + "'"));
            }
            boolean bl = isNewAttribute = !initialWorkItem.containsAttribute(attributeName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("enforce() filter '" + this.name + "' isNewAttribute '" + isNewAttribute + "'"));
            }
            if (isNewAttribute && this.isAddAllowed()) {
                initialWorkItem.getAttributes().put(attributeName, modifiedWorkItem.getAttribute(attributeName));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Added new attribute '" + attributeName + "'"));
                continue;
            }
            if (isNewAttribute) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Dropped new attribute '" + attributeName + "'"));
                continue;
            }
            if (((Object)modifiedWorkItem.getAttribute(attributeName)).equals(initialWorkItem.getAttribute(attributeName))) {
                log.debug((Object)"enforce() Same value");
                continue;
            }
            if (!this.allowRead(attributeName)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Discarding modification on hidden attribute '" + attributeName + "'"));
                continue;
            }
            if (!this.allowWrite(attributeName)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Discarding modification on attribute '" + attributeName + "'"));
                continue;
            }
            initialWorkItem.getAttributes().put(attributeName, modifiedWorkItem.getAttribute(attributeName));
        }
        log.debug((Object)"enforce() checking removal of attributes (is it allowed ?)");
        if (this.removeAllowed) {
            log.debug((Object)"enforce() checking removal of attributes (it is allowed)");
            ArrayList<String> fieldsToRemove = new ArrayList<String>(initialWorkItem.getAttributes().size());
            it = initialWorkItem.getAttributes().keySet().iterator();
            while (it.hasNext()) {
                String fieldName = ((StringAttribute)it.next()).toString();
                if (modifiedWorkItem.containsAttribute(fieldName) || !this.allowWrite(fieldName)) continue;
                fieldsToRemove.add(fieldName);
                log.debug((Object)("enforce() removing field '" + fieldName + "'"));
            }
            it = fieldsToRemove.iterator();
            while (it.hasNext()) {
                initialWorkItem.removeAttribute((String)it.next());
            }
        }
        return initialWorkItem;
    }

    public static Filter getNoFilter() {
        return noFilter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class NoFilter
    extends Filter {
        public NoFilter() {
            this.setName(this.getClass().getName());
            this.setType(0);
            this.setAddAllowed(true);
            this.setRemoveAllowed(true);
            this.setEntries(new ArrayList(0));
        }
    }
}

