/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.participants;

import java.util.HashMap;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.history.History;
import openwfe.org.engine.participants.AbstractParticipant;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;

public class LeafParticipant
extends AbstractParticipant {
    public static final String P_DISPATCHER_CLASS = "dispatcherClass";
    private String dispatcherClassName = null;
    static /* synthetic */ Class class$openwfe$org$engine$dispatch$LocalDispatcher;

    public void init(String regex, Map params) {
        super.init(regex, params);
        this.dispatcherClassName = MapUtils.getAsString((Map)params, (String)P_DISPATCHER_CLASS);
    }

    public String getDispatcherClassName() {
        return this.dispatcherClassName;
    }

    public void setDispatcherClassName(String s) {
        this.dispatcherClassName = s;
    }

    protected WorkItemDispatcher instantiateDispatcher(ApplicationContext context, WorkItem wi) throws DispatchingException {
        WorkItemDispatcher dispatcher = null;
        String dClassName = null;
        dClassName = this.isLocalDelivery(context, wi) ? (class$openwfe$org$engine$dispatch$LocalDispatcher == null ? (class$openwfe$org$engine$dispatch$LocalDispatcher = LeafParticipant.class$("openwfe.org.engine.dispatch.LocalDispatcher")) : class$openwfe$org$engine$dispatch$LocalDispatcher).getName() : this.dispatcherClassName;
        if (dClassName == null) {
            throw new DispatchingException("participant '" + this.getRegex() + "' is missing a " + "'dispatcherClass' parameter, " + "cannot dispatch workitems to it");
        }
        try {
            Class<?> dispatcherClass = Class.forName(this.dispatcherClassName);
            dispatcher = (WorkItemDispatcher)dispatcherClass.newInstance();
            HashMap<String, String> dispatcherParams = new HashMap<String, String>();
            dispatcherParams.putAll(this.getParams());
            dispatcherParams.put("__participant__", this.getRegex());
            dispatcher.init(this.getRegex() + ".dispatcher", context, dispatcherParams);
        }
        catch (Exception e) {
            throw new DispatchingException("Failed to instantiate dispatcher '" + this.dispatcherClassName + "' for participant '" + this.getRegex() + "'", e);
        }
        return dispatcher;
    }

    protected boolean isLocalDelivery(ApplicationContext context, WorkItem wi) {
        Object participantName = null;
        String selfParticipantName = context.getApplicationName();
        if (wi instanceof InFlowItem) {
            return selfParticipantName.equals(((InFlowItem)wi).getParticipantName());
        }
        return false;
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        InFlowItem ifi;
        WorkItemDispatcher dispatcher = this.instantiateDispatcher(context, wi);
        if (wi instanceof InFlowItem && (ifi = (InFlowItem)wi).getParticipantName() == null) {
            ifi.setParticipantName(this.getRegex());
        }
        wi.touch();
        History history = Definitions.getHistory(context);
        if (wi instanceof InFlowWorkItem && history != null) {
            InFlowWorkItem ifwi = (InFlowWorkItem)wi;
            history.log(ifwi.getLastExpressionId(), ifwi, "+DIS", ifwi.getParticipantName(), this.getClass().getName());
        }
        return dispatcher.dispatch(wi);
    }

    protected void reply(ApplicationContext context, WorkItem wi) throws DispatchingException {
        InFlowWorkItem ifwi = (InFlowWorkItem)wi;
        try {
            Definitions.getExpressionPool(context).reply(ifwi.getId(), ifwi);
        }
        catch (Throwable t) {
            throw new DispatchingException("failed to feed back workitem to engine", t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

