/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.Utils;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.time.Time;

public class HistoryItem
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6342388322728713196L;
    public String date = null;
    public String author = null;
    public String host = null;
    public String text = null;
    public String wfdName = "";
    public String wfdRevision = "";
    public String wfInstanceId = null;
    public String expressionId = null;

    public HistoryItem() {
    }

    public HistoryItem(FlowExpressionId fei) {
        this.date = Time.toIsoDate();
        this.wfdName = fei.getWorkflowDefinitionName();
        this.wfdRevision = fei.getWorkflowDefinitionRevision();
        this.wfInstanceId = fei.getWorkflowInstanceId();
        this.expressionId = fei.getExpressionId();
    }

    public String getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getHost() {
        return this.host;
    }

    public String getText() {
        return this.text;
    }

    public String getWorkflowDefinitionName() {
        return this.wfdName;
    }

    public String getWorkflowDefinitionRevision() {
        return this.wfdRevision;
    }

    public String getWorkflowInstanceId() {
        return this.wfInstanceId;
    }

    public String getExpressionId() {
        return this.expressionId;
    }

    public void setDate(String isoDate) {
        this.date = isoDate;
    }

    public void setAuthor(String s) {
        this.author = s;
    }

    public void setHost(String s) {
        this.host = s;
    }

    public void setText(String s) {
        this.text = s;
    }

    public void setWorkflowDefinitionName(String s) {
        this.wfdName = s;
    }

    public void setWorkflowDefinitionRevision(String s) {
        this.wfdRevision = s;
    }

    public void setWorkflowInstanceId(String s) {
        this.wfInstanceId = s;
    }

    public void setExpressionId(String s) {
        this.expressionId = s;
    }

    public Object clone() {
        HistoryItem result = new HistoryItem();
        result.date = Utils.copyString((String)this.date);
        result.author = Utils.copyString((String)this.author);
        result.host = Utils.copyString((String)this.host);
        result.text = Utils.copyString((String)this.text);
        result.wfdName = Utils.copyString((String)this.wfdName);
        result.wfdRevision = Utils.copyString((String)this.wfdRevision);
        result.wfInstanceId = Utils.copyString((String)this.wfInstanceId);
        result.expressionId = Utils.copyString((String)this.expressionId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.getClass().getName()).append(" ").append(" date=\"").append(this.date).append("\"").append(" author=\"").append(this.author).append("\"").append(" host=\"").append(this.host).append("\"").append(" text=\"").append(this.text).append("\"").append(" wfdName=\"").append(this.wfdName).append("\"").append(" wfdRevision=\"").append(this.wfdRevision).append("\"").append(" wfInstanceId=\"").append(this.wfInstanceId).append("\"").append(" expressionId=\"").append(this.expressionId).append("\"").append(")");
        return sb.toString();
    }

    public static List copyHistoryList(List history) {
        ArrayList<Object> result = new ArrayList<Object>(history.size());
        Iterator it = history.iterator();
        while (it.hasNext()) {
            HistoryItem hi = (HistoryItem)it.next();
            result.add(hi.clone());
        }
        return result;
    }
}

