/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import openwfe.org.Utils;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.time.Time;

public class InFlowWorkItem
extends InFlowItem {
    static final long serialVersionUID = 4549009226611843819L;
    private String dispatchTime = null;
    private Filter filter = null;
    private List history = null;

    public InFlowWorkItem() {
    }

    public InFlowWorkItem(LaunchItem li) {
        this.setAttributes(li.getAttributes());
        this.setHistory(new ArrayList(0));
    }

    public InFlowWorkItem(StringMapAttribute sma) {
        this.setAttributes(sma);
        this.setHistory(new ArrayList(0));
    }

    public String getDispatchTime() {
        return this.dispatchTime;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List getHistory() {
        return this.history;
    }

    public void setDispatchTime(String isoDate) {
        this.dispatchTime = isoDate;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public void setHistory(List l) {
        this.history = l;
    }

    public FlowExpressionId getLastExpressionId() {
        return this.getId();
    }

    public void addHistoryItem(String author, String text) {
        this.addHistoryItem(null, author, text);
    }

    public void addHistoryItem(FlowExpressionId fei, String author, String text) {
        HistoryItem hi = new HistoryItem();
        hi.setAuthor(author);
        hi.setDate(Time.toIsoDate());
        hi.setText(text);
        if (fei == null) {
            fei = this.getLastExpressionId();
        }
        if (fei != null) {
            hi.setWorkflowDefinitionName(fei.getWorkflowDefinitionName());
            hi.setWorkflowDefinitionRevision(fei.getWorkflowDefinitionRevision());
            hi.setWorkflowInstanceId(fei.getWorkflowInstanceId());
        }
        try {
            InetAddress add = InetAddress.getLocalHost();
            hi.setHost(add.getHostName() + " / " + add.getHostAddress());
        }
        catch (UnknownHostException uhe) {
            hi.setHost("" + uhe);
        }
        if (this.history == null) {
            this.history = new ArrayList(1);
        }
        this.history.add(hi);
    }

    public Object clone() {
        InFlowWorkItem clone = new InFlowWorkItem();
        clone.setAttributes((StringMapAttribute)this.getAttributes().clone());
        if (this.getId() != null) {
            clone.setId(this.getId().copy());
        }
        clone.setParticipantName(Utils.copyString((String)this.getParticipantName()));
        clone.setDispatchTime(Utils.copyString((String)this.getDispatchTime()));
        clone.setLastModified(Time.toIsoDate());
        clone.setFilter(this.getFilter());
        clone.setHistory(HistoryItem.copyHistoryList(this.history));
        return clone;
    }
}

