/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import openwfe.org.ReflectionUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;

public class MapAttribute
extends CollectionAttribute {
    static final long serialVersionUID = -1843868545451617886L;
    public static final String K_KEYSET = "__keyset__";
    private Map map = new LinkedHashMap();

    public MapAttribute() {
    }

    public MapAttribute(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map m) {
        this.map = m;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Attribute get(Attribute key) {
        return (Attribute)this.map.get(key);
    }

    public Attribute get(String key) {
        if (key.equals(K_KEYSET)) {
            return new ListAttribute(this.map.keySet());
        }
        return (Attribute)this.map.get(new StringAttribute(key));
    }

    public void put(Attribute key, Attribute value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public void remove(Attribute key) {
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public Object clone() {
        MapAttribute clone = (MapAttribute)ReflectionUtils.newInstance((Object)this);
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Attribute key = (Attribute)it.next();
            Attribute value = this.get(key);
            clone.put((Attribute)key.clone(), this.clone(value));
        }
        return clone;
    }

    private Attribute clone(Attribute a) {
        if (a == null) {
            return null;
        }
        return (Attribute)a.clone();
    }

    public void putAll(MapAttribute ma) {
        this.map.putAll(ma.getMap());
    }

    public void cput(String key, Attribute value) {
        this.put(new StringAttribute(key), value);
    }
}

