/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public class StringMapAttribute
extends MapAttribute {
    static final long serialVersionUID = -297013353044083805L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$workitem$StringMapAttribute == null ? (class$openwfe$org$engine$workitem$StringMapAttribute = StringMapAttribute.class$("openwfe.org.engine.workitem.StringMapAttribute")) : class$openwfe$org$engine$workitem$StringMapAttribute).getName());
    static /* synthetic */ Class class$openwfe$org$engine$workitem$StringMapAttribute;

    public StringMapAttribute() {
    }

    public StringMapAttribute(int initialCapacity) {
        super(initialCapacity);
    }

    public Attribute get(String key) {
        return (Attribute)this.getMap().get(new StringAttribute(key));
    }

    public String sget(String key) {
        Attribute a = this.get(key);
        if (a == null) {
            return null;
        }
        return a.toString();
    }

    public void put(String key, Attribute value) {
        this.getMap().put(new StringAttribute(key), value);
    }

    public void puts(String key, String value) {
        this.getMap().put(new StringAttribute(key), new StringAttribute(value));
    }

    public void remove(String key) {
        log.debug((Object)("remove() key '" + key + "'"));
        this.getMap().remove(new StringAttribute(key));
    }

    public boolean hasKey(String key) {
        return this.get(key) != null;
    }

    public Set keyNamesMatching(String regex) {
        HashSet<String> result = new HashSet<String>();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.matches(regex)) continue;
            result.add(key);
        }
        return result;
    }

    public Set stringKeySet() {
        Set initialSet = super.keySet();
        HashSet<String> set = new HashSet<String>();
        Iterator it = initialSet.iterator();
        while (it.hasNext()) {
            set.add(it.next().toString());
        }
        return set;
    }

    public Iterator alphaStringIterator() {
        LinkedList keyList = new LinkedList(this.stringKeySet());
        Collections.sort(keyList);
        return keyList.iterator();
    }

    public Iterator fieldIterator(String fieldName) {
        Attribute a = this.get(fieldName);
        if (a == null) {
            return null;
        }
        if (a instanceof ListAttribute) {
            List l = AttributeUtils.list2java((ListAttribute)a);
            return l.iterator();
        }
        String[] ss = a.toString().trim().split(", *");
        return Arrays.asList(ss).iterator();
    }

    public Attribute getField(String fieldName) {
        return CollectionAttribute.lookupAttribute(fieldName, this);
    }

    public void unsetField(String fieldName) {
        this.setField(fieldName, null);
    }

    public void setField(String fieldName, Object value) {
        int idot;
        Attribute aValue = null;
        if (value != null) {
            aValue = value instanceof Attribute ? (Attribute)value : new StringAttribute(value.toString());
        }
        if ((idot = fieldName.lastIndexOf(".")) < 0) {
            if (aValue == null) {
                this.remove(fieldName);
            } else {
                this.put(fieldName, aValue);
            }
            return;
        }
        CollectionAttribute container = CollectionAttribute.lookupContainer(fieldName, this);
        if (container == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setField() could not follow path >" + fieldName + "<. Did not set or unset anything."));
            }
            return;
        }
        String key = fieldName.substring(idot + 1);
        container.cput(key, aValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

