/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.io.Serializable;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeException;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.time.Time;

public abstract class WorkItem
implements Cloneable,
Serializable {
    static final long serialVersionUID = -7773035923790384871L;
    private String lastModified = null;
    private StringMapAttribute attributes = new StringMapAttribute();

    public String getLastModified() {
        return this.lastModified;
    }

    public StringMapAttribute getAttributes() {
        return this.attributes;
    }

    public void setLastModified(String isoDate) {
        this.lastModified = isoDate;
    }

    public void setAttributes(StringMapAttribute m) {
        this.attributes = m;
    }

    public Attribute getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, Attribute attributeValue) throws AttributeException {
        if (this.attributes == null) {
            this.attributes = new StringMapAttribute(1);
        }
        if (!this.attributes.stringKeySet().contains(attributeName)) {
            throw new AttributeException("WorkItem doesn't contain any attribute named '" + attributeName + "'");
        }
        this.attributes.put(attributeName, attributeValue);
        this.touch();
    }

    public void addAttribute(String attributeName, Attribute attributeValue) throws AttributeException {
        if (this.attributes == null) {
            this.attributes = new StringMapAttribute(1);
        }
        if (this.attributes.stringKeySet().contains(attributeName)) {
            throw new AttributeException("WorkItem already contains an attribute named '" + attributeName + "'");
        }
        this.attributes.put(attributeName, attributeValue);
        this.touch();
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
        this.touch();
    }

    public boolean containsAttribute(String attributeName) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.stringKeySet().contains(attributeName);
    }

    public void touch() {
        this.lastModified = Time.toIsoDate();
    }
}

